/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCardsRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<String> customerId;
    private final OptionalNullable<Boolean> includeDisabled;
    private final OptionalNullable<String> referenceId;
    private final String sortOrder;

    @JsonCreator
    public ListCardsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="include_disabled") Boolean includeDisabled, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="sort_order") String sortOrder) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.customerId = OptionalNullable.of((Object)customerId);
        this.includeDisabled = OptionalNullable.of((Object)includeDisabled);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.sortOrder = sortOrder;
    }

    protected ListCardsRequest(OptionalNullable<String> cursor, OptionalNullable<String> customerId, OptionalNullable<Boolean> includeDisabled, OptionalNullable<String> referenceId, String sortOrder) {
        this.cursor = cursor;
        this.customerId = customerId;
        this.includeDisabled = includeDisabled;
        this.referenceId = referenceId;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="include_disabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeDisabled() {
        return this.includeDisabled;
    }

    @JsonIgnore
    public Boolean getIncludeDisabled() {
        return (Boolean)OptionalNullable.getFrom(this.includeDisabled);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.customerId, this.includeDisabled, this.referenceId, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCardsRequest)) {
            return false;
        }
        ListCardsRequest other = (ListCardsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.includeDisabled, other.includeDisabled) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "ListCardsRequest [cursor=" + this.cursor + ", customerId=" + this.customerId + ", includeDisabled=" + this.includeDisabled + ", referenceId=" + this.referenceId + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortOrder(this.getSortOrder());
        builder.cursor = this.internalGetCursor();
        builder.customerId = this.internalGetCustomerId();
        builder.includeDisabled = this.internalGetIncludeDisabled();
        builder.referenceId = this.internalGetReferenceId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<String> customerId;
        private OptionalNullable<Boolean> includeDisabled;
        private OptionalNullable<String> referenceId;
        private String sortOrder;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder includeDisabled(Boolean includeDisabled) {
            this.includeDisabled = OptionalNullable.of((Object)includeDisabled);
            return this;
        }

        public Builder unsetIncludeDisabled() {
            this.includeDisabled = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListCardsRequest build() {
            return new ListCardsRequest(this.cursor, this.customerId, this.includeDisabled, this.referenceId, this.sortOrder);
        }
    }
}

