/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCashDrawerShiftEventsRequest {
    private final String locationId;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListCashDrawerShiftEventsRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.locationId = locationId;
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListCashDrawerShiftEventsRequest(String locationId, OptionalNullable<Integer> limit, OptionalNullable<String> cursor) {
        this.locationId = locationId;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftEventsRequest)) {
            return false;
        }
        ListCashDrawerShiftEventsRequest other = (ListCashDrawerShiftEventsRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCashDrawerShiftEventsRequest [locationId=" + this.locationId + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId);
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private String locationId;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListCashDrawerShiftEventsRequest build() {
            return new ListCashDrawerShiftEventsRequest(this.locationId, this.limit, this.cursor);
        }
    }
}

