/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCatalogRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<String> types;
    private final OptionalNullable<Long> catalogVersion;

    @JsonCreator
    public ListCatalogRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="types") String types, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.types = OptionalNullable.of((Object)types);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
    }

    protected ListCatalogRequest(OptionalNullable<String> cursor, OptionalNullable<String> types, OptionalNullable<Long> catalogVersion) {
        this.cursor = cursor;
        this.types = types;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTypes() {
        return this.types;
    }

    @JsonIgnore
    public String getTypes() {
        return (String)OptionalNullable.getFrom(this.types);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.types, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCatalogRequest)) {
            return false;
        }
        ListCatalogRequest other = (ListCatalogRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.types, other.types) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "ListCatalogRequest [cursor=" + this.cursor + ", types=" + this.types + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.cursor = this.internalGetCursor();
        builder.types = this.internalGetTypes();
        builder.catalogVersion = this.internalGetCatalogVersion();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<String> types;
        private OptionalNullable<Long> catalogVersion;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder types(String types) {
            this.types = OptionalNullable.of((Object)types);
            return this;
        }

        public Builder unsetTypes() {
            this.types = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public ListCatalogRequest build() {
            return new ListCatalogRequest(this.cursor, this.types, this.catalogVersion);
        }
    }
}

