/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomAttribute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCustomerCustomAttributesResponse {
    private HttpContext httpContext;
    private final List<CustomAttribute> customAttributes;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListCustomerCustomAttributesResponse(@JsonProperty(value="custom_attributes") List<CustomAttribute> customAttributes, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.customAttributes = customAttributes;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="custom_attributes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.customAttributes, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomerCustomAttributesResponse)) {
            return false;
        }
        ListCustomerCustomAttributesResponse other = (ListCustomerCustomAttributesResponse)obj;
        return Objects.equals(this.customAttributes, other.customAttributes) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListCustomerCustomAttributesResponse [customAttributes=" + this.customAttributes + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customAttributes(this.getCustomAttributes()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<CustomAttribute> customAttributes;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder customAttributes(List<CustomAttribute> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListCustomerCustomAttributesResponse build() {
            ListCustomerCustomAttributesResponse model = new ListCustomerCustomAttributesResponse(this.customAttributes, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

