/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCustomerSegmentsRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Integer> limit;

    @JsonCreator
    public ListCustomerSegmentsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.limit = OptionalNullable.of((Object)limit);
    }

    protected ListCustomerSegmentsRequest(OptionalNullable<String> cursor, OptionalNullable<Integer> limit) {
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomerSegmentsRequest)) {
            return false;
        }
        ListCustomerSegmentsRequest other = (ListCustomerSegmentsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "ListCustomerSegmentsRequest [cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.cursor = this.internalGetCursor();
        builder.limit = this.internalGetLimit();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<Integer> limit;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public ListCustomerSegmentsRequest build() {
            return new ListCustomerSegmentsRequest(this.cursor, this.limit);
        }
    }
}

