/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCustomersRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Integer> limit;
    private final String sortField;
    private final String sortOrder;

    @JsonCreator
    public ListCustomersRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="sort_field") String sortField, @JsonProperty(value="sort_order") String sortOrder) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.limit = OptionalNullable.of((Object)limit);
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    protected ListCustomersRequest(OptionalNullable<String> cursor, OptionalNullable<Integer> limit, String sortField, String sortOrder) {
        this.cursor = cursor;
        this.limit = limit;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="sort_field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortField() {
        return this.sortField;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.sortField, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomersRequest)) {
            return false;
        }
        ListCustomersRequest other = (ListCustomersRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sortField, other.sortField) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "ListCustomersRequest [cursor=" + this.cursor + ", limit=" + this.limit + ", sortField=" + this.sortField + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortField(this.getSortField()).sortOrder(this.getSortOrder());
        builder.cursor = this.internalGetCursor();
        builder.limit = this.internalGetLimit();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<Integer> limit;
        private String sortField;
        private String sortOrder;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListCustomersRequest build() {
            return new ListCustomersRequest(this.cursor, this.limit, this.sortField, this.sortOrder);
        }
    }
}

