/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Customer;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCustomersResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Customer> customers;
    private final String cursor;

    @JsonCreator
    public ListCustomersResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="customers") List<Customer> customers, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.customers = customers;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="customers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Customer> getCustomers() {
        return this.customers;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customers, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomersResponse)) {
            return false;
        }
        ListCustomersResponse other = (ListCustomersResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.customers, other.customers) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCustomersResponse [errors=" + this.errors + ", customers=" + this.customers + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).customers(this.getCustomers()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Customer> customers;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder customers(List<Customer> customers) {
            this.customers = customers;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCustomersResponse build() {
            ListCustomersResponse model = new ListCustomersResponse(this.errors, this.customers, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

