/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.DisputeEvidence;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListDisputeEvidenceResponse {
    private HttpContext httpContext;
    private final List<DisputeEvidence> evidence;
    private final List<Error> errors;
    private final String cursor;

    @JsonCreator
    public ListDisputeEvidenceResponse(@JsonProperty(value="evidence") List<DisputeEvidence> evidence, @JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cursor") String cursor) {
        this.evidence = evidence;
        this.errors = errors;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="evidence")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<DisputeEvidence> getEvidence() {
        return this.evidence;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.evidence, this.errors, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDisputeEvidenceResponse)) {
            return false;
        }
        ListDisputeEvidenceResponse other = (ListDisputeEvidenceResponse)obj;
        return Objects.equals(this.evidence, other.evidence) && Objects.equals(this.errors, other.errors) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListDisputeEvidenceResponse [evidence=" + this.evidence + ", errors=" + this.errors + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().evidence(this.getEvidence()).errors(this.getErrors()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<DisputeEvidence> evidence;
        private List<Error> errors;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder evidence(List<DisputeEvidence> evidence) {
            this.evidence = evidence;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListDisputeEvidenceResponse build() {
            ListDisputeEvidenceResponse model = new ListDisputeEvidenceResponse(this.evidence, this.errors, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

