/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListEmployeeWagesRequest {
    private final OptionalNullable<String> employeeId;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListEmployeeWagesRequest(@JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.employeeId = OptionalNullable.of((Object)employeeId);
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListEmployeeWagesRequest(OptionalNullable<String> employeeId, OptionalNullable<Integer> limit, OptionalNullable<String> cursor) {
        this.employeeId = employeeId;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmployeeId() {
        return this.employeeId;
    }

    @JsonIgnore
    public String getEmployeeId() {
        return (String)OptionalNullable.getFrom(this.employeeId);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.employeeId, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListEmployeeWagesRequest)) {
            return false;
        }
        ListEmployeeWagesRequest other = (ListEmployeeWagesRequest)obj;
        return Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListEmployeeWagesRequest [employeeId=" + this.employeeId + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.employeeId = this.internalGetEmployeeId();
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> employeeId;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;

        public Builder employeeId(String employeeId) {
            this.employeeId = OptionalNullable.of((Object)employeeId);
            return this;
        }

        public Builder unsetEmployeeId() {
            this.employeeId = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListEmployeeWagesRequest build() {
            return new ListEmployeeWagesRequest(this.employeeId, this.limit, this.cursor);
        }
    }
}

