/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.EmployeeWage;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListEmployeeWagesResponse {
    private HttpContext httpContext;
    private final List<EmployeeWage> employeeWages;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListEmployeeWagesResponse(@JsonProperty(value="employee_wages") List<EmployeeWage> employeeWages, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.employeeWages = employeeWages;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="employee_wages")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<EmployeeWage> getEmployeeWages() {
        return this.employeeWages;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.employeeWages, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListEmployeeWagesResponse)) {
            return false;
        }
        ListEmployeeWagesResponse other = (ListEmployeeWagesResponse)obj;
        return Objects.equals(this.employeeWages, other.employeeWages) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListEmployeeWagesResponse [employeeWages=" + this.employeeWages + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().employeeWages(this.getEmployeeWages()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<EmployeeWage> employeeWages;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder employeeWages(List<EmployeeWage> employeeWages) {
            this.employeeWages = employeeWages;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListEmployeeWagesResponse build() {
            ListEmployeeWagesResponse model = new ListEmployeeWagesResponse(this.employeeWages, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

