/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListLocationCustomAttributeDefinitionsRequest {
    private final String visibilityFilter;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListLocationCustomAttributeDefinitionsRequest(@JsonProperty(value="visibility_filter") String visibilityFilter, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.visibilityFilter = visibilityFilter;
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListLocationCustomAttributeDefinitionsRequest(String visibilityFilter, OptionalNullable<Integer> limit, OptionalNullable<String> cursor) {
        this.visibilityFilter = visibilityFilter;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="visibility_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVisibilityFilter() {
        return this.visibilityFilter;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.visibilityFilter, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListLocationCustomAttributeDefinitionsRequest)) {
            return false;
        }
        ListLocationCustomAttributeDefinitionsRequest other = (ListLocationCustomAttributeDefinitionsRequest)obj;
        return Objects.equals(this.visibilityFilter, other.visibilityFilter) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListLocationCustomAttributeDefinitionsRequest [visibilityFilter=" + this.visibilityFilter + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().visibilityFilter(this.getVisibilityFilter());
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private String visibilityFilter;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;

        public Builder visibilityFilter(String visibilityFilter) {
            this.visibilityFilter = visibilityFilter;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListLocationCustomAttributeDefinitionsRequest build() {
            return new ListLocationCustomAttributeDefinitionsRequest(this.visibilityFilter, this.limit, this.cursor);
        }
    }
}

