/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListLocationCustomAttributesRequest {
    private final String visibilityFilter;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Boolean> withDefinitions;

    @JsonCreator
    public ListLocationCustomAttributesRequest(@JsonProperty(value="visibility_filter") String visibilityFilter, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="with_definitions") Boolean withDefinitions) {
        this.visibilityFilter = visibilityFilter;
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
        this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
    }

    protected ListLocationCustomAttributesRequest(String visibilityFilter, OptionalNullable<Integer> limit, OptionalNullable<String> cursor, OptionalNullable<Boolean> withDefinitions) {
        this.visibilityFilter = visibilityFilter;
        this.limit = limit;
        this.cursor = cursor;
        this.withDefinitions = withDefinitions;
    }

    @JsonGetter(value="visibility_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVisibilityFilter() {
        return this.visibilityFilter;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="with_definitions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetWithDefinitions() {
        return this.withDefinitions;
    }

    @JsonIgnore
    public Boolean getWithDefinitions() {
        return (Boolean)OptionalNullable.getFrom(this.withDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.visibilityFilter, this.limit, this.cursor, this.withDefinitions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListLocationCustomAttributesRequest)) {
            return false;
        }
        ListLocationCustomAttributesRequest other = (ListLocationCustomAttributesRequest)obj;
        return Objects.equals(this.visibilityFilter, other.visibilityFilter) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.withDefinitions, other.withDefinitions);
    }

    public String toString() {
        return "ListLocationCustomAttributesRequest [visibilityFilter=" + this.visibilityFilter + ", limit=" + this.limit + ", cursor=" + this.cursor + ", withDefinitions=" + this.withDefinitions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().visibilityFilter(this.getVisibilityFilter());
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        builder.withDefinitions = this.internalGetWithDefinitions();
        return builder;
    }

    public static class Builder {
        private String visibilityFilter;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;
        private OptionalNullable<Boolean> withDefinitions;

        public Builder visibilityFilter(String visibilityFilter) {
            this.visibilityFilter = visibilityFilter;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder withDefinitions(Boolean withDefinitions) {
            this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
            return this;
        }

        public Builder unsetWithDefinitions() {
            this.withDefinitions = null;
            return this;
        }

        public ListLocationCustomAttributesRequest build() {
            return new ListLocationCustomAttributesRequest(this.visibilityFilter, this.limit, this.cursor, this.withDefinitions);
        }
    }
}

