/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyPromotion;
import java.util.List;
import java.util.Objects;

public class ListLoyaltyPromotionsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<LoyaltyPromotion> loyaltyPromotions;
    private final String cursor;

    @JsonCreator
    public ListLoyaltyPromotionsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="loyalty_promotions") List<LoyaltyPromotion> loyaltyPromotions, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.loyaltyPromotions = loyaltyPromotions;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="loyalty_promotions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyPromotion> getLoyaltyPromotions() {
        return this.loyaltyPromotions;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyPromotions, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListLoyaltyPromotionsResponse)) {
            return false;
        }
        ListLoyaltyPromotionsResponse other = (ListLoyaltyPromotionsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.loyaltyPromotions, other.loyaltyPromotions) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListLoyaltyPromotionsResponse [errors=" + this.errors + ", loyaltyPromotions=" + this.loyaltyPromotions + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).loyaltyPromotions(this.getLoyaltyPromotions()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<LoyaltyPromotion> loyaltyPromotions;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder loyaltyPromotions(List<LoyaltyPromotion> loyaltyPromotions) {
            this.loyaltyPromotions = loyaltyPromotions;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListLoyaltyPromotionsResponse build() {
            ListLoyaltyPromotionsResponse model = new ListLoyaltyPromotionsResponse(this.errors, this.loyaltyPromotions, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

