/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Merchant;
import java.util.List;
import java.util.Objects;

public class ListMerchantsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Merchant> merchant;
    private final Integer cursor;

    @JsonCreator
    public ListMerchantsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="merchant") List<Merchant> merchant, @JsonProperty(value="cursor") Integer cursor) {
        this.errors = errors;
        this.merchant = merchant;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="merchant")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Merchant> getMerchant() {
        return this.merchant;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.merchant, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListMerchantsResponse)) {
            return false;
        }
        ListMerchantsResponse other = (ListMerchantsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.merchant, other.merchant) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListMerchantsResponse [errors=" + this.errors + ", merchant=" + this.merchant + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).merchant(this.getMerchant()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Merchant> merchant;
        private Integer cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder merchant(List<Merchant> merchant) {
            this.merchant = merchant;
            return this;
        }

        public Builder cursor(Integer cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListMerchantsResponse build() {
            ListMerchantsResponse model = new ListMerchantsResponse(this.errors, this.merchant, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

