/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListOrderCustomAttributesRequest {
    private final String visibilityFilter;
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<Boolean> withDefinitions;

    @JsonCreator
    public ListOrderCustomAttributesRequest(@JsonProperty(value="visibility_filter") String visibilityFilter, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="with_definitions") Boolean withDefinitions) {
        this.visibilityFilter = visibilityFilter;
        this.cursor = OptionalNullable.of((Object)cursor);
        this.limit = OptionalNullable.of((Object)limit);
        this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
    }

    protected ListOrderCustomAttributesRequest(String visibilityFilter, OptionalNullable<String> cursor, OptionalNullable<Integer> limit, OptionalNullable<Boolean> withDefinitions) {
        this.visibilityFilter = visibilityFilter;
        this.cursor = cursor;
        this.limit = limit;
        this.withDefinitions = withDefinitions;
    }

    @JsonGetter(value="visibility_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVisibilityFilter() {
        return this.visibilityFilter;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="with_definitions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetWithDefinitions() {
        return this.withDefinitions;
    }

    @JsonIgnore
    public Boolean getWithDefinitions() {
        return (Boolean)OptionalNullable.getFrom(this.withDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.visibilityFilter, this.cursor, this.limit, this.withDefinitions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListOrderCustomAttributesRequest)) {
            return false;
        }
        ListOrderCustomAttributesRequest other = (ListOrderCustomAttributesRequest)obj;
        return Objects.equals(this.visibilityFilter, other.visibilityFilter) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.withDefinitions, other.withDefinitions);
    }

    public String toString() {
        return "ListOrderCustomAttributesRequest [visibilityFilter=" + this.visibilityFilter + ", cursor=" + this.cursor + ", limit=" + this.limit + ", withDefinitions=" + this.withDefinitions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().visibilityFilter(this.getVisibilityFilter());
        builder.cursor = this.internalGetCursor();
        builder.limit = this.internalGetLimit();
        builder.withDefinitions = this.internalGetWithDefinitions();
        return builder;
    }

    public static class Builder {
        private String visibilityFilter;
        private OptionalNullable<String> cursor;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<Boolean> withDefinitions;

        public Builder visibilityFilter(String visibilityFilter) {
            this.visibilityFilter = visibilityFilter;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder withDefinitions(Boolean withDefinitions) {
            this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
            return this;
        }

        public Builder unsetWithDefinitions() {
            this.withDefinitions = null;
            return this;
        }

        public ListOrderCustomAttributesRequest build() {
            return new ListOrderCustomAttributesRequest(this.visibilityFilter, this.cursor, this.limit, this.withDefinitions);
        }
    }
}

