/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.PayoutEntry;
import java.util.List;
import java.util.Objects;

public class ListPayoutEntriesResponse {
    private HttpContext httpContext;
    private final List<PayoutEntry> payoutEntries;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListPayoutEntriesResponse(@JsonProperty(value="payout_entries") List<PayoutEntry> payoutEntries, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.payoutEntries = payoutEntries;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="payout_entries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PayoutEntry> getPayoutEntries() {
        return this.payoutEntries;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.payoutEntries, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPayoutEntriesResponse)) {
            return false;
        }
        ListPayoutEntriesResponse other = (ListPayoutEntriesResponse)obj;
        return Objects.equals(this.payoutEntries, other.payoutEntries) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListPayoutEntriesResponse [payoutEntries=" + this.payoutEntries + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().payoutEntries(this.getPayoutEntries()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<PayoutEntry> payoutEntries;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder payoutEntries(List<PayoutEntry> payoutEntries) {
            this.payoutEntries = payoutEntries;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListPayoutEntriesResponse build() {
            ListPayoutEntriesResponse model = new ListPayoutEntriesResponse(this.payoutEntries, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

