/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyEventAccumulatePoints;
import com.squareup.square.models.LoyaltyEventAccumulatePromotionPoints;
import com.squareup.square.models.LoyaltyEventAdjustPoints;
import com.squareup.square.models.LoyaltyEventCreateReward;
import com.squareup.square.models.LoyaltyEventDeleteReward;
import com.squareup.square.models.LoyaltyEventExpirePoints;
import com.squareup.square.models.LoyaltyEventOther;
import com.squareup.square.models.LoyaltyEventRedeemReward;
import java.util.Objects;

public class LoyaltyEvent {
    private final String id;
    private final String type;
    private final String createdAt;
    private final LoyaltyEventAccumulatePoints accumulatePoints;
    private final LoyaltyEventCreateReward createReward;
    private final LoyaltyEventRedeemReward redeemReward;
    private final LoyaltyEventDeleteReward deleteReward;
    private final LoyaltyEventAdjustPoints adjustPoints;
    private final String loyaltyAccountId;
    private final String locationId;
    private final String source;
    private final LoyaltyEventExpirePoints expirePoints;
    private final LoyaltyEventOther otherEvent;
    private final LoyaltyEventAccumulatePromotionPoints accumulatePromotionPoints;

    @JsonCreator
    public LoyaltyEvent(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="loyalty_account_id") String loyaltyAccountId, @JsonProperty(value="source") String source, @JsonProperty(value="accumulate_points") LoyaltyEventAccumulatePoints accumulatePoints, @JsonProperty(value="create_reward") LoyaltyEventCreateReward createReward, @JsonProperty(value="redeem_reward") LoyaltyEventRedeemReward redeemReward, @JsonProperty(value="delete_reward") LoyaltyEventDeleteReward deleteReward, @JsonProperty(value="adjust_points") LoyaltyEventAdjustPoints adjustPoints, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="expire_points") LoyaltyEventExpirePoints expirePoints, @JsonProperty(value="other_event") LoyaltyEventOther otherEvent, @JsonProperty(value="accumulate_promotion_points") LoyaltyEventAccumulatePromotionPoints accumulatePromotionPoints) {
        this.id = id;
        this.type = type;
        this.createdAt = createdAt;
        this.accumulatePoints = accumulatePoints;
        this.createReward = createReward;
        this.redeemReward = redeemReward;
        this.deleteReward = deleteReward;
        this.adjustPoints = adjustPoints;
        this.loyaltyAccountId = loyaltyAccountId;
        this.locationId = locationId;
        this.source = source;
        this.expirePoints = expirePoints;
        this.otherEvent = otherEvent;
        this.accumulatePromotionPoints = accumulatePromotionPoints;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="accumulate_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventAccumulatePoints getAccumulatePoints() {
        return this.accumulatePoints;
    }

    @JsonGetter(value="create_reward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventCreateReward getCreateReward() {
        return this.createReward;
    }

    @JsonGetter(value="redeem_reward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventRedeemReward getRedeemReward() {
        return this.redeemReward;
    }

    @JsonGetter(value="delete_reward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventDeleteReward getDeleteReward() {
        return this.deleteReward;
    }

    @JsonGetter(value="adjust_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventAdjustPoints getAdjustPoints() {
        return this.adjustPoints;
    }

    @JsonGetter(value="loyalty_account_id")
    public String getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonGetter(value="expire_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventExpirePoints getExpirePoints() {
        return this.expirePoints;
    }

    @JsonGetter(value="other_event")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventOther getOtherEvent() {
        return this.otherEvent;
    }

    @JsonGetter(value="accumulate_promotion_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEventAccumulatePromotionPoints getAccumulatePromotionPoints() {
        return this.accumulatePromotionPoints;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.createdAt, this.accumulatePoints, this.createReward, this.redeemReward, this.deleteReward, this.adjustPoints, this.loyaltyAccountId, this.locationId, this.source, this.expirePoints, this.otherEvent, this.accumulatePromotionPoints);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEvent)) {
            return false;
        }
        LoyaltyEvent other = (LoyaltyEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.accumulatePoints, other.accumulatePoints) && Objects.equals(this.createReward, other.createReward) && Objects.equals(this.redeemReward, other.redeemReward) && Objects.equals(this.deleteReward, other.deleteReward) && Objects.equals(this.adjustPoints, other.adjustPoints) && Objects.equals(this.loyaltyAccountId, other.loyaltyAccountId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.source, other.source) && Objects.equals(this.expirePoints, other.expirePoints) && Objects.equals(this.otherEvent, other.otherEvent) && Objects.equals(this.accumulatePromotionPoints, other.accumulatePromotionPoints);
    }

    public String toString() {
        return "LoyaltyEvent [id=" + this.id + ", type=" + this.type + ", createdAt=" + this.createdAt + ", loyaltyAccountId=" + this.loyaltyAccountId + ", source=" + this.source + ", accumulatePoints=" + this.accumulatePoints + ", createReward=" + this.createReward + ", redeemReward=" + this.redeemReward + ", deleteReward=" + this.deleteReward + ", adjustPoints=" + this.adjustPoints + ", locationId=" + this.locationId + ", expirePoints=" + this.expirePoints + ", otherEvent=" + this.otherEvent + ", accumulatePromotionPoints=" + this.accumulatePromotionPoints + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.type, this.createdAt, this.loyaltyAccountId, this.source).accumulatePoints(this.getAccumulatePoints()).createReward(this.getCreateReward()).redeemReward(this.getRedeemReward()).deleteReward(this.getDeleteReward()).adjustPoints(this.getAdjustPoints()).locationId(this.getLocationId()).expirePoints(this.getExpirePoints()).otherEvent(this.getOtherEvent()).accumulatePromotionPoints(this.getAccumulatePromotionPoints());
        return builder;
    }

    public static class Builder {
        private String id;
        private String type;
        private String createdAt;
        private String loyaltyAccountId;
        private String source;
        private LoyaltyEventAccumulatePoints accumulatePoints;
        private LoyaltyEventCreateReward createReward;
        private LoyaltyEventRedeemReward redeemReward;
        private LoyaltyEventDeleteReward deleteReward;
        private LoyaltyEventAdjustPoints adjustPoints;
        private String locationId;
        private LoyaltyEventExpirePoints expirePoints;
        private LoyaltyEventOther otherEvent;
        private LoyaltyEventAccumulatePromotionPoints accumulatePromotionPoints;

        public Builder(String id, String type, String createdAt, String loyaltyAccountId, String source) {
            this.id = id;
            this.type = type;
            this.createdAt = createdAt;
            this.loyaltyAccountId = loyaltyAccountId;
            this.source = source;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder loyaltyAccountId(String loyaltyAccountId) {
            this.loyaltyAccountId = loyaltyAccountId;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder accumulatePoints(LoyaltyEventAccumulatePoints accumulatePoints) {
            this.accumulatePoints = accumulatePoints;
            return this;
        }

        public Builder createReward(LoyaltyEventCreateReward createReward) {
            this.createReward = createReward;
            return this;
        }

        public Builder redeemReward(LoyaltyEventRedeemReward redeemReward) {
            this.redeemReward = redeemReward;
            return this;
        }

        public Builder deleteReward(LoyaltyEventDeleteReward deleteReward) {
            this.deleteReward = deleteReward;
            return this;
        }

        public Builder adjustPoints(LoyaltyEventAdjustPoints adjustPoints) {
            this.adjustPoints = adjustPoints;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder expirePoints(LoyaltyEventExpirePoints expirePoints) {
            this.expirePoints = expirePoints;
            return this;
        }

        public Builder otherEvent(LoyaltyEventOther otherEvent) {
            this.otherEvent = otherEvent;
            return this;
        }

        public Builder accumulatePromotionPoints(LoyaltyEventAccumulatePromotionPoints accumulatePromotionPoints) {
            this.accumulatePromotionPoints = accumulatePromotionPoints;
            return this;
        }

        public LoyaltyEvent build() {
            return new LoyaltyEvent(this.id, this.type, this.createdAt, this.loyaltyAccountId, this.source, this.accumulatePoints, this.createReward, this.redeemReward, this.deleteReward, this.adjustPoints, this.locationId, this.expirePoints, this.otherEvent, this.accumulatePromotionPoints);
        }
    }
}

