/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObjectReference;
import com.squareup.square.models.LoyaltyProgramRewardDefinition;
import java.util.Objects;

public class LoyaltyProgramRewardTier {
    private final String id;
    private final int points;
    private final String name;
    private final LoyaltyProgramRewardDefinition definition;
    private final String createdAt;
    private final CatalogObjectReference pricingRuleReference;

    @JsonCreator
    public LoyaltyProgramRewardTier(@JsonProperty(value="points") int points, @JsonProperty(value="pricing_rule_reference") CatalogObjectReference pricingRuleReference, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="definition") LoyaltyProgramRewardDefinition definition, @JsonProperty(value="created_at") String createdAt) {
        this.id = id;
        this.points = points;
        this.name = name;
        this.definition = definition;
        this.createdAt = createdAt;
        this.pricingRuleReference = pricingRuleReference;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="definition")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramRewardDefinition getDefinition() {
        return this.definition;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="pricing_rule_reference")
    public CatalogObjectReference getPricingRuleReference() {
        return this.pricingRuleReference;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.points, this.name, this.definition, this.createdAt, this.pricingRuleReference);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramRewardTier)) {
            return false;
        }
        LoyaltyProgramRewardTier other = (LoyaltyProgramRewardTier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.points, other.points) && Objects.equals(this.name, other.name) && Objects.equals(this.definition, other.definition) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.pricingRuleReference, other.pricingRuleReference);
    }

    public String toString() {
        return "LoyaltyProgramRewardTier [points=" + this.points + ", pricingRuleReference=" + this.pricingRuleReference + ", id=" + this.id + ", name=" + this.name + ", definition=" + this.definition + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.points, this.pricingRuleReference).id(this.getId()).name(this.getName()).definition(this.getDefinition()).createdAt(this.getCreatedAt());
        return builder;
    }

    public static class Builder {
        private int points;
        private CatalogObjectReference pricingRuleReference;
        private String id;
        private String name;
        private LoyaltyProgramRewardDefinition definition;
        private String createdAt;

        public Builder(int points, CatalogObjectReference pricingRuleReference) {
            this.points = points;
            this.pricingRuleReference = pricingRuleReference;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public Builder pricingRuleReference(CatalogObjectReference pricingRuleReference) {
            this.pricingRuleReference = pricingRuleReference;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder definition(LoyaltyProgramRewardDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public LoyaltyProgramRewardTier build() {
            return new LoyaltyProgramRewardTier(this.points, this.pricingRuleReference, this.id, this.name, this.definition, this.createdAt);
        }
    }
}

