/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class LoyaltyPromotionAvailableTimeData {
    private final String startDate;
    private final String endDate;
    private final List<String> timePeriods;

    @JsonCreator
    public LoyaltyPromotionAvailableTimeData(@JsonProperty(value="time_periods") List<String> timePeriods, @JsonProperty(value="start_date") String startDate, @JsonProperty(value="end_date") String endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.timePeriods = timePeriods;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonGetter(value="end_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonGetter(value="time_periods")
    public List<String> getTimePeriods() {
        return this.timePeriods;
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.timePeriods);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyPromotionAvailableTimeData)) {
            return false;
        }
        LoyaltyPromotionAvailableTimeData other = (LoyaltyPromotionAvailableTimeData)obj;
        return Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate) && Objects.equals(this.timePeriods, other.timePeriods);
    }

    public String toString() {
        return "LoyaltyPromotionAvailableTimeData [timePeriods=" + this.timePeriods + ", startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.timePeriods).startDate(this.getStartDate()).endDate(this.getEndDate());
        return builder;
    }

    public static class Builder {
        private List<String> timePeriods;
        private String startDate;
        private String endDate;

        public Builder(List<String> timePeriods) {
            this.timePeriods = timePeriods;
        }

        public Builder timePeriods(List<String> timePeriods) {
            this.timePeriods = timePeriods;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public LoyaltyPromotionAvailableTimeData build() {
            return new LoyaltyPromotionAvailableTimeData(this.timePeriods, this.startDate, this.endDate);
        }
    }
}

