/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.MeasurementUnitCustom;
import java.util.Objects;

public class MeasurementUnit {
    private final MeasurementUnitCustom customUnit;
    private final String areaUnit;
    private final String lengthUnit;
    private final String volumeUnit;
    private final String weightUnit;
    private final String genericUnit;
    private final String timeUnit;
    private final String type;

    @JsonCreator
    public MeasurementUnit(@JsonProperty(value="custom_unit") MeasurementUnitCustom customUnit, @JsonProperty(value="area_unit") String areaUnit, @JsonProperty(value="length_unit") String lengthUnit, @JsonProperty(value="volume_unit") String volumeUnit, @JsonProperty(value="weight_unit") String weightUnit, @JsonProperty(value="generic_unit") String genericUnit, @JsonProperty(value="time_unit") String timeUnit, @JsonProperty(value="type") String type) {
        this.customUnit = customUnit;
        this.areaUnit = areaUnit;
        this.lengthUnit = lengthUnit;
        this.volumeUnit = volumeUnit;
        this.weightUnit = weightUnit;
        this.genericUnit = genericUnit;
        this.timeUnit = timeUnit;
        this.type = type;
    }

    @JsonGetter(value="custom_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnitCustom getCustomUnit() {
        return this.customUnit;
    }

    @JsonGetter(value="area_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAreaUnit() {
        return this.areaUnit;
    }

    @JsonGetter(value="length_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLengthUnit() {
        return this.lengthUnit;
    }

    @JsonGetter(value="volume_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVolumeUnit() {
        return this.volumeUnit;
    }

    @JsonGetter(value="weight_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getWeightUnit() {
        return this.weightUnit;
    }

    @JsonGetter(value="generic_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGenericUnit() {
        return this.genericUnit;
    }

    @JsonGetter(value="time_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimeUnit() {
        return this.timeUnit;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.customUnit, this.areaUnit, this.lengthUnit, this.volumeUnit, this.weightUnit, this.genericUnit, this.timeUnit, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MeasurementUnit)) {
            return false;
        }
        MeasurementUnit other = (MeasurementUnit)obj;
        return Objects.equals(this.customUnit, other.customUnit) && Objects.equals(this.areaUnit, other.areaUnit) && Objects.equals(this.lengthUnit, other.lengthUnit) && Objects.equals(this.volumeUnit, other.volumeUnit) && Objects.equals(this.weightUnit, other.weightUnit) && Objects.equals(this.genericUnit, other.genericUnit) && Objects.equals(this.timeUnit, other.timeUnit) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "MeasurementUnit [customUnit=" + this.customUnit + ", areaUnit=" + this.areaUnit + ", lengthUnit=" + this.lengthUnit + ", volumeUnit=" + this.volumeUnit + ", weightUnit=" + this.weightUnit + ", genericUnit=" + this.genericUnit + ", timeUnit=" + this.timeUnit + ", type=" + this.type + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customUnit(this.getCustomUnit()).areaUnit(this.getAreaUnit()).lengthUnit(this.getLengthUnit()).volumeUnit(this.getVolumeUnit()).weightUnit(this.getWeightUnit()).genericUnit(this.getGenericUnit()).timeUnit(this.getTimeUnit()).type(this.getType());
        return builder;
    }

    public static class Builder {
        private MeasurementUnitCustom customUnit;
        private String areaUnit;
        private String lengthUnit;
        private String volumeUnit;
        private String weightUnit;
        private String genericUnit;
        private String timeUnit;
        private String type;

        public Builder customUnit(MeasurementUnitCustom customUnit) {
            this.customUnit = customUnit;
            return this;
        }

        public Builder areaUnit(String areaUnit) {
            this.areaUnit = areaUnit;
            return this;
        }

        public Builder lengthUnit(String lengthUnit) {
            this.lengthUnit = lengthUnit;
            return this;
        }

        public Builder volumeUnit(String volumeUnit) {
            this.volumeUnit = volumeUnit;
            return this;
        }

        public Builder weightUnit(String weightUnit) {
            this.weightUnit = weightUnit;
            return this;
        }

        public Builder genericUnit(String genericUnit) {
            this.genericUnit = genericUnit;
            return this;
        }

        public Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public MeasurementUnit build() {
            return new MeasurementUnit(this.customUnit, this.areaUnit, this.lengthUnit, this.volumeUnit, this.weightUnit, this.genericUnit, this.timeUnit, this.type);
        }
    }
}

