/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class MeasurementUnitCustom {
    private final String name;
    private final String abbreviation;

    @JsonCreator
    public MeasurementUnitCustom(@JsonProperty(value="name") String name, @JsonProperty(value="abbreviation") String abbreviation) {
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="abbreviation")
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.abbreviation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MeasurementUnitCustom)) {
            return false;
        }
        MeasurementUnitCustom other = (MeasurementUnitCustom)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.abbreviation, other.abbreviation);
    }

    public String toString() {
        return "MeasurementUnitCustom [name=" + this.name + ", abbreviation=" + this.abbreviation + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.abbreviation);
        return builder;
    }

    public static class Builder {
        private String name;
        private String abbreviation;

        public Builder(String name, String abbreviation) {
            this.name = name;
            this.abbreviation = abbreviation;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public MeasurementUnitCustom build() {
            return new MeasurementUnitCustom(this.name, this.abbreviation);
        }
    }
}

