/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ModifierLocationOverrides {
    private final OptionalNullable<String> locationId;
    private final Money priceMoney;

    @JsonCreator
    public ModifierLocationOverrides(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="price_money") Money priceMoney) {
        this.locationId = OptionalNullable.of((Object)locationId);
        this.priceMoney = priceMoney;
    }

    protected ModifierLocationOverrides(OptionalNullable<String> locationId, Money priceMoney) {
        this.locationId = locationId;
        this.priceMoney = priceMoney;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.priceMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModifierLocationOverrides)) {
            return false;
        }
        ModifierLocationOverrides other = (ModifierLocationOverrides)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.priceMoney, other.priceMoney);
    }

    public String toString() {
        return "ModifierLocationOverrides [locationId=" + this.locationId + ", priceMoney=" + this.priceMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().priceMoney(this.getPriceMoney());
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationId;
        private Money priceMoney;

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public ModifierLocationOverrides build() {
            return new ModifierLocationOverrides(this.locationId, this.priceMoney);
        }
    }
}

