/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class ObtainTokenRequest {
    private final String clientId;
    private final OptionalNullable<String> clientSecret;
    private final OptionalNullable<String> code;
    private final OptionalNullable<String> redirectUri;
    private final String grantType;
    private final OptionalNullable<String> refreshToken;
    private final OptionalNullable<String> migrationToken;
    private final OptionalNullable<List<String>> scopes;
    private final OptionalNullable<Boolean> shortLived;
    private final OptionalNullable<String> codeVerifier;

    @JsonCreator
    public ObtainTokenRequest(@JsonProperty(value="client_id") String clientId, @JsonProperty(value="grant_type") String grantType, @JsonProperty(value="client_secret") String clientSecret, @JsonProperty(value="code") String code, @JsonProperty(value="redirect_uri") String redirectUri, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="migration_token") String migrationToken, @JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="short_lived") Boolean shortLived, @JsonProperty(value="code_verifier") String codeVerifier) {
        this.clientId = clientId;
        this.clientSecret = OptionalNullable.of((Object)clientSecret);
        this.code = OptionalNullable.of((Object)code);
        this.redirectUri = OptionalNullable.of((Object)redirectUri);
        this.grantType = grantType;
        this.refreshToken = OptionalNullable.of((Object)refreshToken);
        this.migrationToken = OptionalNullable.of((Object)migrationToken);
        this.scopes = OptionalNullable.of(scopes);
        this.shortLived = OptionalNullable.of((Object)shortLived);
        this.codeVerifier = OptionalNullable.of((Object)codeVerifier);
    }

    protected ObtainTokenRequest(String clientId, String grantType, OptionalNullable<String> clientSecret, OptionalNullable<String> code, OptionalNullable<String> redirectUri, OptionalNullable<String> refreshToken, OptionalNullable<String> migrationToken, OptionalNullable<List<String>> scopes, OptionalNullable<Boolean> shortLived, OptionalNullable<String> codeVerifier) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.migrationToken = migrationToken;
        this.scopes = scopes;
        this.shortLived = shortLived;
        this.codeVerifier = codeVerifier;
    }

    @JsonGetter(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @JsonGetter(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetClientSecret() {
        return this.clientSecret;
    }

    @JsonIgnore
    public String getClientSecret() {
        return (String)OptionalNullable.getFrom(this.clientSecret);
    }

    @JsonGetter(value="code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCode() {
        return this.code;
    }

    @JsonIgnore
    public String getCode() {
        return (String)OptionalNullable.getFrom(this.code);
    }

    @JsonGetter(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRedirectUri() {
        return this.redirectUri;
    }

    @JsonIgnore
    public String getRedirectUri() {
        return (String)OptionalNullable.getFrom(this.redirectUri);
    }

    @JsonGetter(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @JsonGetter(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRefreshToken() {
        return this.refreshToken;
    }

    @JsonIgnore
    public String getRefreshToken() {
        return (String)OptionalNullable.getFrom(this.refreshToken);
    }

    @JsonGetter(value="migration_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMigrationToken() {
        return this.migrationToken;
    }

    @JsonIgnore
    public String getMigrationToken() {
        return (String)OptionalNullable.getFrom(this.migrationToken);
    }

    @JsonGetter(value="scopes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetScopes() {
        return this.scopes;
    }

    @JsonIgnore
    public List<String> getScopes() {
        return (List)OptionalNullable.getFrom(this.scopes);
    }

    @JsonGetter(value="short_lived")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetShortLived() {
        return this.shortLived;
    }

    @JsonIgnore
    public Boolean getShortLived() {
        return (Boolean)OptionalNullable.getFrom(this.shortLived);
    }

    @JsonGetter(value="code_verifier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCodeVerifier() {
        return this.codeVerifier;
    }

    @JsonIgnore
    public String getCodeVerifier() {
        return (String)OptionalNullable.getFrom(this.codeVerifier);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.code, this.redirectUri, this.grantType, this.refreshToken, this.migrationToken, this.scopes, this.shortLived, this.codeVerifier);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObtainTokenRequest)) {
            return false;
        }
        ObtainTokenRequest other = (ObtainTokenRequest)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.code, other.code) && Objects.equals(this.redirectUri, other.redirectUri) && Objects.equals(this.grantType, other.grantType) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.migrationToken, other.migrationToken) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.shortLived, other.shortLived) && Objects.equals(this.codeVerifier, other.codeVerifier);
    }

    public String toString() {
        return "ObtainTokenRequest [clientId=" + this.clientId + ", grantType=" + this.grantType + ", clientSecret=" + this.clientSecret + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ", refreshToken=" + this.refreshToken + ", migrationToken=" + this.migrationToken + ", scopes=" + this.scopes + ", shortLived=" + this.shortLived + ", codeVerifier=" + this.codeVerifier + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.clientId, this.grantType);
        builder.clientSecret = this.internalGetClientSecret();
        builder.code = this.internalGetCode();
        builder.redirectUri = this.internalGetRedirectUri();
        builder.refreshToken = this.internalGetRefreshToken();
        builder.migrationToken = this.internalGetMigrationToken();
        builder.scopes = this.internalGetScopes();
        builder.shortLived = this.internalGetShortLived();
        builder.codeVerifier = this.internalGetCodeVerifier();
        return builder;
    }

    public static class Builder {
        private String clientId;
        private String grantType;
        private OptionalNullable<String> clientSecret;
        private OptionalNullable<String> code;
        private OptionalNullable<String> redirectUri;
        private OptionalNullable<String> refreshToken;
        private OptionalNullable<String> migrationToken;
        private OptionalNullable<List<String>> scopes;
        private OptionalNullable<Boolean> shortLived;
        private OptionalNullable<String> codeVerifier;

        public Builder(String clientId, String grantType) {
            this.clientId = clientId;
            this.grantType = grantType;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = OptionalNullable.of((Object)clientSecret);
            return this;
        }

        public Builder unsetClientSecret() {
            this.clientSecret = null;
            return this;
        }

        public Builder code(String code) {
            this.code = OptionalNullable.of((Object)code);
            return this;
        }

        public Builder unsetCode() {
            this.code = null;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = OptionalNullable.of((Object)redirectUri);
            return this;
        }

        public Builder unsetRedirectUri() {
            this.redirectUri = null;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = OptionalNullable.of((Object)refreshToken);
            return this;
        }

        public Builder unsetRefreshToken() {
            this.refreshToken = null;
            return this;
        }

        public Builder migrationToken(String migrationToken) {
            this.migrationToken = OptionalNullable.of((Object)migrationToken);
            return this;
        }

        public Builder unsetMigrationToken() {
            this.migrationToken = null;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = OptionalNullable.of(scopes);
            return this;
        }

        public Builder unsetScopes() {
            this.scopes = null;
            return this;
        }

        public Builder shortLived(Boolean shortLived) {
            this.shortLived = OptionalNullable.of((Object)shortLived);
            return this;
        }

        public Builder unsetShortLived() {
            this.shortLived = null;
            return this;
        }

        public Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = OptionalNullable.of((Object)codeVerifier);
            return this;
        }

        public Builder unsetCodeVerifier() {
            this.codeVerifier = null;
            return this;
        }

        public ObtainTokenRequest build() {
            return new ObtainTokenRequest(this.clientId, this.grantType, this.clientSecret, this.code, this.redirectUri, this.refreshToken, this.migrationToken, this.scopes, this.shortLived, this.codeVerifier);
        }
    }
}

