/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderCreated {
    private final OptionalNullable<String> orderId;
    private final Integer version;
    private final OptionalNullable<String> locationId;
    private final String state;
    private final String createdAt;

    @JsonCreator
    public OrderCreated(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="state") String state, @JsonProperty(value="created_at") String createdAt) {
        this.orderId = OptionalNullable.of((Object)orderId);
        this.version = version;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.state = state;
        this.createdAt = createdAt;
    }

    protected OrderCreated(OptionalNullable<String> orderId, Integer version, OptionalNullable<String> locationId, String state, String createdAt) {
        this.orderId = orderId;
        this.version = version;
        this.locationId = locationId;
        this.state = state;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.locationId, this.state, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderCreated)) {
            return false;
        }
        OrderCreated other = (OrderCreated)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.state, other.state) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "OrderCreated [orderId=" + this.orderId + ", version=" + this.version + ", locationId=" + this.locationId + ", state=" + this.state + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().version(this.getVersion()).state(this.getState()).createdAt(this.getCreatedAt());
        builder.orderId = this.internalGetOrderId();
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> orderId;
        private Integer version;
        private OptionalNullable<String> locationId;
        private String state;
        private String createdAt;

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public OrderCreated build() {
            return new OrderCreated(this.orderId, this.version, this.locationId, this.state, this.createdAt);
        }
    }
}

