/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderFulfillmentDeliveryDetails;
import com.squareup.square.models.OrderFulfillmentFulfillmentEntry;
import com.squareup.square.models.OrderFulfillmentPickupDetails;
import com.squareup.square.models.OrderFulfillmentShipmentDetails;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderFulfillment {
    private final OptionalNullable<String> uid;
    private final String type;
    private final String state;
    private final String lineItemApplication;
    private final List<OrderFulfillmentFulfillmentEntry> entries;
    private final OptionalNullable<Map<String, String>> metadata;
    private final OrderFulfillmentPickupDetails pickupDetails;
    private final OrderFulfillmentShipmentDetails shipmentDetails;
    private final OrderFulfillmentDeliveryDetails deliveryDetails;

    @JsonCreator
    public OrderFulfillment(@JsonProperty(value="uid") String uid, @JsonProperty(value="type") String type, @JsonProperty(value="state") String state, @JsonProperty(value="line_item_application") String lineItemApplication, @JsonProperty(value="entries") List<OrderFulfillmentFulfillmentEntry> entries, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="pickup_details") OrderFulfillmentPickupDetails pickupDetails, @JsonProperty(value="shipment_details") OrderFulfillmentShipmentDetails shipmentDetails, @JsonProperty(value="delivery_details") OrderFulfillmentDeliveryDetails deliveryDetails) {
        this.uid = OptionalNullable.of((Object)uid);
        this.type = type;
        this.state = state;
        this.lineItemApplication = lineItemApplication;
        this.entries = entries;
        this.metadata = OptionalNullable.of(metadata);
        this.pickupDetails = pickupDetails;
        this.shipmentDetails = shipmentDetails;
        this.deliveryDetails = deliveryDetails;
    }

    protected OrderFulfillment(OptionalNullable<String> uid, String type, String state, String lineItemApplication, List<OrderFulfillmentFulfillmentEntry> entries, OptionalNullable<Map<String, String>> metadata, OrderFulfillmentPickupDetails pickupDetails, OrderFulfillmentShipmentDetails shipmentDetails, OrderFulfillmentDeliveryDetails deliveryDetails) {
        this.uid = uid;
        this.type = type;
        this.state = state;
        this.lineItemApplication = lineItemApplication;
        this.entries = entries;
        this.metadata = metadata;
        this.pickupDetails = pickupDetails;
        this.shipmentDetails = shipmentDetails;
        this.deliveryDetails = deliveryDetails;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="line_item_application")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLineItemApplication() {
        return this.lineItemApplication;
    }

    @JsonGetter(value="entries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderFulfillmentFulfillmentEntry> getEntries() {
        return this.entries;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    @JsonGetter(value="pickup_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentPickupDetails getPickupDetails() {
        return this.pickupDetails;
    }

    @JsonGetter(value="shipment_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentShipmentDetails getShipmentDetails() {
        return this.shipmentDetails;
    }

    @JsonGetter(value="delivery_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentDeliveryDetails getDeliveryDetails() {
        return this.deliveryDetails;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.type, this.state, this.lineItemApplication, this.entries, this.metadata, this.pickupDetails, this.shipmentDetails, this.deliveryDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillment)) {
            return false;
        }
        OrderFulfillment other = (OrderFulfillment)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.type, other.type) && Objects.equals(this.state, other.state) && Objects.equals(this.lineItemApplication, other.lineItemApplication) && Objects.equals(this.entries, other.entries) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.pickupDetails, other.pickupDetails) && Objects.equals(this.shipmentDetails, other.shipmentDetails) && Objects.equals(this.deliveryDetails, other.deliveryDetails);
    }

    public String toString() {
        return "OrderFulfillment [uid=" + this.uid + ", type=" + this.type + ", state=" + this.state + ", lineItemApplication=" + this.lineItemApplication + ", entries=" + this.entries + ", metadata=" + this.metadata + ", pickupDetails=" + this.pickupDetails + ", shipmentDetails=" + this.shipmentDetails + ", deliveryDetails=" + this.deliveryDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).state(this.getState()).lineItemApplication(this.getLineItemApplication()).entries(this.getEntries()).pickupDetails(this.getPickupDetails()).shipmentDetails(this.getShipmentDetails()).deliveryDetails(this.getDeliveryDetails());
        builder.uid = this.internalGetUid();
        builder.metadata = this.internalGetMetadata();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private String type;
        private String state;
        private String lineItemApplication;
        private List<OrderFulfillmentFulfillmentEntry> entries;
        private OptionalNullable<Map<String, String>> metadata;
        private OrderFulfillmentPickupDetails pickupDetails;
        private OrderFulfillmentShipmentDetails shipmentDetails;
        private OrderFulfillmentDeliveryDetails deliveryDetails;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder lineItemApplication(String lineItemApplication) {
            this.lineItemApplication = lineItemApplication;
            return this;
        }

        public Builder entries(List<OrderFulfillmentFulfillmentEntry> entries) {
            this.entries = entries;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public Builder pickupDetails(OrderFulfillmentPickupDetails pickupDetails) {
            this.pickupDetails = pickupDetails;
            return this;
        }

        public Builder shipmentDetails(OrderFulfillmentShipmentDetails shipmentDetails) {
            this.shipmentDetails = shipmentDetails;
            return this;
        }

        public Builder deliveryDetails(OrderFulfillmentDeliveryDetails deliveryDetails) {
            this.deliveryDetails = deliveryDetails;
            return this;
        }

        public OrderFulfillment build() {
            return new OrderFulfillment(this.uid, this.type, this.state, this.lineItemApplication, this.entries, this.metadata, this.pickupDetails, this.shipmentDetails, this.deliveryDetails);
        }
    }
}

