/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderFulfillmentUpdatedUpdate;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class OrderFulfillmentUpdated {
    private final OptionalNullable<String> orderId;
    private final Integer version;
    private final OptionalNullable<String> locationId;
    private final String state;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<List<OrderFulfillmentUpdatedUpdate>> fulfillmentUpdate;

    @JsonCreator
    public OrderFulfillmentUpdated(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="state") String state, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="fulfillment_update") List<OrderFulfillmentUpdatedUpdate> fulfillmentUpdate) {
        this.orderId = OptionalNullable.of((Object)orderId);
        this.version = version;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.fulfillmentUpdate = OptionalNullable.of(fulfillmentUpdate);
    }

    protected OrderFulfillmentUpdated(OptionalNullable<String> orderId, Integer version, OptionalNullable<String> locationId, String state, String createdAt, String updatedAt, OptionalNullable<List<OrderFulfillmentUpdatedUpdate>> fulfillmentUpdate) {
        this.orderId = orderId;
        this.version = version;
        this.locationId = locationId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.fulfillmentUpdate = fulfillmentUpdate;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="fulfillment_update")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderFulfillmentUpdatedUpdate>> internalGetFulfillmentUpdate() {
        return this.fulfillmentUpdate;
    }

    @JsonIgnore
    public List<OrderFulfillmentUpdatedUpdate> getFulfillmentUpdate() {
        return (List)OptionalNullable.getFrom(this.fulfillmentUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.locationId, this.state, this.createdAt, this.updatedAt, this.fulfillmentUpdate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentUpdated)) {
            return false;
        }
        OrderFulfillmentUpdated other = (OrderFulfillmentUpdated)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.state, other.state) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.fulfillmentUpdate, other.fulfillmentUpdate);
    }

    public String toString() {
        return "OrderFulfillmentUpdated [orderId=" + this.orderId + ", version=" + this.version + ", locationId=" + this.locationId + ", state=" + this.state + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", fulfillmentUpdate=" + this.fulfillmentUpdate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().version(this.getVersion()).state(this.getState()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.orderId = this.internalGetOrderId();
        builder.locationId = this.internalGetLocationId();
        builder.fulfillmentUpdate = this.internalGetFulfillmentUpdate();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> orderId;
        private Integer version;
        private OptionalNullable<String> locationId;
        private String state;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<List<OrderFulfillmentUpdatedUpdate>> fulfillmentUpdate;

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder fulfillmentUpdate(List<OrderFulfillmentUpdatedUpdate> fulfillmentUpdate) {
            this.fulfillmentUpdate = OptionalNullable.of(fulfillmentUpdate);
            return this;
        }

        public Builder unsetFulfillmentUpdate() {
            this.fulfillmentUpdate = null;
            return this;
        }

        public OrderFulfillmentUpdated build() {
            return new OrderFulfillmentUpdated(this.orderId, this.version, this.locationId, this.state, this.createdAt, this.updatedAt, this.fulfillmentUpdate);
        }
    }
}

