/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedDiscount;
import com.squareup.square.models.OrderLineItemAppliedServiceCharge;
import com.squareup.square.models.OrderLineItemAppliedTax;
import com.squareup.square.models.OrderLineItemModifier;
import com.squareup.square.models.OrderLineItemPricingBlocklists;
import com.squareup.square.models.OrderQuantityUnit;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderLineItem {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> name;
    private final String quantity;
    private final OrderQuantityUnit quantityUnit;
    private final OptionalNullable<String> note;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<String> variationName;
    private final String itemType;
    private final OptionalNullable<Map<String, String>> metadata;
    private final OptionalNullable<List<OrderLineItemModifier>> modifiers;
    private final OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes;
    private final OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts;
    private final OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges;
    private final Money basePriceMoney;
    private final Money variationTotalPriceMoney;
    private final Money grossSalesMoney;
    private final Money totalTaxMoney;
    private final Money totalDiscountMoney;
    private final Money totalMoney;
    private final OrderLineItemPricingBlocklists pricingBlocklists;
    private final Money totalServiceChargeMoney;

    @JsonCreator
    public OrderLineItem(@JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="name") String name, @JsonProperty(value="quantity_unit") OrderQuantityUnit quantityUnit, @JsonProperty(value="note") String note, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="variation_name") String variationName, @JsonProperty(value="item_type") String itemType, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="modifiers") List<OrderLineItemModifier> modifiers, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes, @JsonProperty(value="applied_discounts") List<OrderLineItemAppliedDiscount> appliedDiscounts, @JsonProperty(value="applied_service_charges") List<OrderLineItemAppliedServiceCharge> appliedServiceCharges, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="variation_total_price_money") Money variationTotalPriceMoney, @JsonProperty(value="gross_sales_money") Money grossSalesMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="total_discount_money") Money totalDiscountMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="pricing_blocklists") OrderLineItemPricingBlocklists pricingBlocklists, @JsonProperty(value="total_service_charge_money") Money totalServiceChargeMoney) {
        this.uid = OptionalNullable.of((Object)uid);
        this.name = OptionalNullable.of((Object)name);
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = OptionalNullable.of((Object)note);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.variationName = OptionalNullable.of((Object)variationName);
        this.itemType = itemType;
        this.metadata = OptionalNullable.of(metadata);
        this.modifiers = OptionalNullable.of(modifiers);
        this.appliedTaxes = OptionalNullable.of(appliedTaxes);
        this.appliedDiscounts = OptionalNullable.of(appliedDiscounts);
        this.appliedServiceCharges = OptionalNullable.of(appliedServiceCharges);
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossSalesMoney = grossSalesMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.pricingBlocklists = pricingBlocklists;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
    }

    protected OrderLineItem(String quantity, OptionalNullable<String> uid, OptionalNullable<String> name, OrderQuantityUnit quantityUnit, OptionalNullable<String> note, OptionalNullable<String> catalogObjectId, OptionalNullable<Long> catalogVersion, OptionalNullable<String> variationName, String itemType, OptionalNullable<Map<String, String>> metadata, OptionalNullable<List<OrderLineItemModifier>> modifiers, OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes, OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts, OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges, Money basePriceMoney, Money variationTotalPriceMoney, Money grossSalesMoney, Money totalTaxMoney, Money totalDiscountMoney, Money totalMoney, OrderLineItemPricingBlocklists pricingBlocklists, Money totalServiceChargeMoney) {
        this.uid = uid;
        this.name = name;
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = note;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.variationName = variationName;
        this.itemType = itemType;
        this.metadata = metadata;
        this.modifiers = modifiers;
        this.appliedTaxes = appliedTaxes;
        this.appliedDiscounts = appliedDiscounts;
        this.appliedServiceCharges = appliedServiceCharges;
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossSalesMoney = grossSalesMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.pricingBlocklists = pricingBlocklists;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="quantity_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderQuantityUnit getQuantityUnit() {
        return this.quantityUnit;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="variation_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetVariationName() {
        return this.variationName;
    }

    @JsonIgnore
    public String getVariationName() {
        return (String)OptionalNullable.getFrom(this.variationName);
    }

    @JsonGetter(value="item_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemType() {
        return this.itemType;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    @JsonGetter(value="modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemModifier>> internalGetModifiers() {
        return this.modifiers;
    }

    @JsonIgnore
    public List<OrderLineItemModifier> getModifiers() {
        return (List)OptionalNullable.getFrom(this.modifiers);
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedTax>> internalGetAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return (List)OptionalNullable.getFrom(this.appliedTaxes);
    }

    @JsonGetter(value="applied_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedDiscount>> internalGetAppliedDiscounts() {
        return this.appliedDiscounts;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedDiscount> getAppliedDiscounts() {
        return (List)OptionalNullable.getFrom(this.appliedDiscounts);
    }

    @JsonGetter(value="applied_service_charges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedServiceCharge>> internalGetAppliedServiceCharges() {
        return this.appliedServiceCharges;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedServiceCharge> getAppliedServiceCharges() {
        return (List)OptionalNullable.getFrom(this.appliedServiceCharges);
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="variation_total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getVariationTotalPriceMoney() {
        return this.variationTotalPriceMoney;
    }

    @JsonGetter(value="gross_sales_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="pricing_blocklists")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderLineItemPricingBlocklists getPricingBlocklists() {
        return this.pricingBlocklists;
    }

    @JsonGetter(value="total_service_charge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalServiceChargeMoney() {
        return this.totalServiceChargeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.metadata, this.modifiers, this.appliedTaxes, this.appliedDiscounts, this.appliedServiceCharges, this.basePriceMoney, this.variationTotalPriceMoney, this.grossSalesMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.pricingBlocklists, this.totalServiceChargeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItem)) {
            return false;
        }
        OrderLineItem other = (OrderLineItem)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityUnit, other.quantityUnit) && Objects.equals(this.note, other.note) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.variationName, other.variationName) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.modifiers, other.modifiers) && Objects.equals(this.appliedTaxes, other.appliedTaxes) && Objects.equals(this.appliedDiscounts, other.appliedDiscounts) && Objects.equals(this.appliedServiceCharges, other.appliedServiceCharges) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.variationTotalPriceMoney, other.variationTotalPriceMoney) && Objects.equals(this.grossSalesMoney, other.grossSalesMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.pricingBlocklists, other.pricingBlocklists) && Objects.equals(this.totalServiceChargeMoney, other.totalServiceChargeMoney);
    }

    public String toString() {
        return "OrderLineItem [quantity=" + this.quantity + ", uid=" + this.uid + ", name=" + this.name + ", quantityUnit=" + this.quantityUnit + ", note=" + this.note + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", variationName=" + this.variationName + ", itemType=" + this.itemType + ", metadata=" + this.metadata + ", modifiers=" + this.modifiers + ", appliedTaxes=" + this.appliedTaxes + ", appliedDiscounts=" + this.appliedDiscounts + ", appliedServiceCharges=" + this.appliedServiceCharges + ", basePriceMoney=" + this.basePriceMoney + ", variationTotalPriceMoney=" + this.variationTotalPriceMoney + ", grossSalesMoney=" + this.grossSalesMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", totalMoney=" + this.totalMoney + ", pricingBlocklists=" + this.pricingBlocklists + ", totalServiceChargeMoney=" + this.totalServiceChargeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.quantity).quantityUnit(this.getQuantityUnit()).itemType(this.getItemType()).basePriceMoney(this.getBasePriceMoney()).variationTotalPriceMoney(this.getVariationTotalPriceMoney()).grossSalesMoney(this.getGrossSalesMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).totalMoney(this.getTotalMoney()).pricingBlocklists(this.getPricingBlocklists()).totalServiceChargeMoney(this.getTotalServiceChargeMoney());
        builder.uid = this.internalGetUid();
        builder.name = this.internalGetName();
        builder.note = this.internalGetNote();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.variationName = this.internalGetVariationName();
        builder.metadata = this.internalGetMetadata();
        builder.modifiers = this.internalGetModifiers();
        builder.appliedTaxes = this.internalGetAppliedTaxes();
        builder.appliedDiscounts = this.internalGetAppliedDiscounts();
        builder.appliedServiceCharges = this.internalGetAppliedServiceCharges();
        return builder;
    }

    public static class Builder {
        private String quantity;
        private OptionalNullable<String> uid;
        private OptionalNullable<String> name;
        private OrderQuantityUnit quantityUnit;
        private OptionalNullable<String> note;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<String> variationName;
        private String itemType;
        private OptionalNullable<Map<String, String>> metadata;
        private OptionalNullable<List<OrderLineItemModifier>> modifiers;
        private OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes;
        private OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts;
        private OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges;
        private Money basePriceMoney;
        private Money variationTotalPriceMoney;
        private Money grossSalesMoney;
        private Money totalTaxMoney;
        private Money totalDiscountMoney;
        private Money totalMoney;
        private OrderLineItemPricingBlocklists pricingBlocklists;
        private Money totalServiceChargeMoney;

        public Builder(String quantity) {
            this.quantity = quantity;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder quantityUnit(OrderQuantityUnit quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder variationName(String variationName) {
            this.variationName = OptionalNullable.of((Object)variationName);
            return this;
        }

        public Builder unsetVariationName() {
            this.variationName = null;
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public Builder modifiers(List<OrderLineItemModifier> modifiers) {
            this.modifiers = OptionalNullable.of(modifiers);
            return this;
        }

        public Builder unsetModifiers() {
            this.modifiers = null;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = OptionalNullable.of(appliedTaxes);
            return this;
        }

        public Builder unsetAppliedTaxes() {
            this.appliedTaxes = null;
            return this;
        }

        public Builder appliedDiscounts(List<OrderLineItemAppliedDiscount> appliedDiscounts) {
            this.appliedDiscounts = OptionalNullable.of(appliedDiscounts);
            return this;
        }

        public Builder unsetAppliedDiscounts() {
            this.appliedDiscounts = null;
            return this;
        }

        public Builder appliedServiceCharges(List<OrderLineItemAppliedServiceCharge> appliedServiceCharges) {
            this.appliedServiceCharges = OptionalNullable.of(appliedServiceCharges);
            return this;
        }

        public Builder unsetAppliedServiceCharges() {
            this.appliedServiceCharges = null;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder variationTotalPriceMoney(Money variationTotalPriceMoney) {
            this.variationTotalPriceMoney = variationTotalPriceMoney;
            return this;
        }

        public Builder grossSalesMoney(Money grossSalesMoney) {
            this.grossSalesMoney = grossSalesMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder pricingBlocklists(OrderLineItemPricingBlocklists pricingBlocklists) {
            this.pricingBlocklists = pricingBlocklists;
            return this;
        }

        public Builder totalServiceChargeMoney(Money totalServiceChargeMoney) {
            this.totalServiceChargeMoney = totalServiceChargeMoney;
            return this;
        }

        public OrderLineItem build() {
            return new OrderLineItem(this.quantity, this.uid, this.name, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.metadata, this.modifiers, this.appliedTaxes, this.appliedDiscounts, this.appliedServiceCharges, this.basePriceMoney, this.variationTotalPriceMoney, this.grossSalesMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.pricingBlocklists, this.totalServiceChargeMoney);
        }
    }
}

