/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderLineItemAppliedServiceCharge {
    private final OptionalNullable<String> uid;
    private final String serviceChargeUid;
    private final Money appliedMoney;

    @JsonCreator
    public OrderLineItemAppliedServiceCharge(@JsonProperty(value="service_charge_uid") String serviceChargeUid, @JsonProperty(value="uid") String uid, @JsonProperty(value="applied_money") Money appliedMoney) {
        this.uid = OptionalNullable.of((Object)uid);
        this.serviceChargeUid = serviceChargeUid;
        this.appliedMoney = appliedMoney;
    }

    protected OrderLineItemAppliedServiceCharge(String serviceChargeUid, OptionalNullable<String> uid, Money appliedMoney) {
        this.uid = uid;
        this.serviceChargeUid = serviceChargeUid;
        this.appliedMoney = appliedMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="service_charge_uid")
    public String getServiceChargeUid() {
        return this.serviceChargeUid;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.serviceChargeUid, this.appliedMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemAppliedServiceCharge)) {
            return false;
        }
        OrderLineItemAppliedServiceCharge other = (OrderLineItemAppliedServiceCharge)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.serviceChargeUid, other.serviceChargeUid) && Objects.equals(this.appliedMoney, other.appliedMoney);
    }

    public String toString() {
        return "OrderLineItemAppliedServiceCharge [serviceChargeUid=" + this.serviceChargeUid + ", uid=" + this.uid + ", appliedMoney=" + this.appliedMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.serviceChargeUid).appliedMoney(this.getAppliedMoney());
        builder.uid = this.internalGetUid();
        return builder;
    }

    public static class Builder {
        private String serviceChargeUid;
        private OptionalNullable<String> uid;
        private Money appliedMoney;

        public Builder(String serviceChargeUid) {
            this.serviceChargeUid = serviceChargeUid;
        }

        public Builder serviceChargeUid(String serviceChargeUid) {
            this.serviceChargeUid = serviceChargeUid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public OrderLineItemAppliedServiceCharge build() {
            return new OrderLineItemAppliedServiceCharge(this.serviceChargeUid, this.uid, this.appliedMoney);
        }
    }
}

