/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Map;
import java.util.Objects;

public class OrderLineItemModifier {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> quantity;
    private final Money basePriceMoney;
    private final Money totalPriceMoney;
    private final OptionalNullable<Map<String, String>> metadata;

    @JsonCreator
    public OrderLineItemModifier(@JsonProperty(value="uid") String uid, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="name") String name, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="total_price_money") Money totalPriceMoney, @JsonProperty(value="metadata") Map<String, String> metadata) {
        this.uid = OptionalNullable.of((Object)uid);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.name = OptionalNullable.of((Object)name);
        this.quantity = OptionalNullable.of((Object)quantity);
        this.basePriceMoney = basePriceMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.metadata = OptionalNullable.of(metadata);
    }

    protected OrderLineItemModifier(OptionalNullable<String> uid, OptionalNullable<String> catalogObjectId, OptionalNullable<Long> catalogVersion, OptionalNullable<String> name, OptionalNullable<String> quantity, Money basePriceMoney, Money totalPriceMoney, OptionalNullable<Map<String, String>> metadata) {
        this.uid = uid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.quantity = quantity;
        this.basePriceMoney = basePriceMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.metadata = metadata;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetQuantity() {
        return this.quantity;
    }

    @JsonIgnore
    public String getQuantity() {
        return (String)OptionalNullable.getFrom(this.quantity);
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemModifier)) {
            return false;
        }
        OrderLineItemModifier other = (OrderLineItemModifier)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.totalPriceMoney, other.totalPriceMoney) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return "OrderLineItemModifier [uid=" + this.uid + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", name=" + this.name + ", quantity=" + this.quantity + ", basePriceMoney=" + this.basePriceMoney + ", totalPriceMoney=" + this.totalPriceMoney + ", metadata=" + this.metadata + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().basePriceMoney(this.getBasePriceMoney()).totalPriceMoney(this.getTotalPriceMoney());
        builder.uid = this.internalGetUid();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.name = this.internalGetName();
        builder.quantity = this.internalGetQuantity();
        builder.metadata = this.internalGetMetadata();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<String> name;
        private OptionalNullable<String> quantity;
        private Money basePriceMoney;
        private Money totalPriceMoney;
        private OptionalNullable<Map<String, String>> metadata;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = OptionalNullable.of((Object)quantity);
            return this;
        }

        public Builder unsetQuantity() {
            this.quantity = null;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder totalPriceMoney(Money totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public OrderLineItemModifier build() {
            return new OrderLineItemModifier(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata);
        }
    }
}

