/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Map;
import java.util.Objects;

public class OrderLineItemTax {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<String> name;
    private final String type;
    private final OptionalNullable<String> percentage;
    private final OptionalNullable<Map<String, String>> metadata;
    private final Money appliedMoney;
    private final String scope;
    private final Boolean autoApplied;

    @JsonCreator
    public OrderLineItemTax(@JsonProperty(value="uid") String uid, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="applied_money") Money appliedMoney, @JsonProperty(value="scope") String scope, @JsonProperty(value="auto_applied") Boolean autoApplied) {
        this.uid = OptionalNullable.of((Object)uid);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.name = OptionalNullable.of((Object)name);
        this.type = type;
        this.percentage = OptionalNullable.of((Object)percentage);
        this.metadata = OptionalNullable.of(metadata);
        this.appliedMoney = appliedMoney;
        this.scope = scope;
        this.autoApplied = autoApplied;
    }

    protected OrderLineItemTax(OptionalNullable<String> uid, OptionalNullable<String> catalogObjectId, OptionalNullable<Long> catalogVersion, OptionalNullable<String> name, String type, OptionalNullable<String> percentage, OptionalNullable<Map<String, String>> metadata, Money appliedMoney, String scope, Boolean autoApplied) {
        this.uid = uid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.type = type;
        this.percentage = percentage;
        this.metadata = metadata;
        this.appliedMoney = appliedMoney;
        this.scope = scope;
        this.autoApplied = autoApplied;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPercentage() {
        return this.percentage;
    }

    @JsonIgnore
    public String getPercentage() {
        return (String)OptionalNullable.getFrom(this.percentage);
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="scope")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScope() {
        return this.scope;
    }

    @JsonGetter(value="auto_applied")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAutoApplied() {
        return this.autoApplied;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.metadata, this.appliedMoney, this.scope, this.autoApplied);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemTax)) {
            return false;
        }
        OrderLineItemTax other = (OrderLineItemTax)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.scope, other.scope) && Objects.equals(this.autoApplied, other.autoApplied);
    }

    public String toString() {
        return "OrderLineItemTax [uid=" + this.uid + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", name=" + this.name + ", type=" + this.type + ", percentage=" + this.percentage + ", metadata=" + this.metadata + ", appliedMoney=" + this.appliedMoney + ", scope=" + this.scope + ", autoApplied=" + this.autoApplied + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).appliedMoney(this.getAppliedMoney()).scope(this.getScope()).autoApplied(this.getAutoApplied());
        builder.uid = this.internalGetUid();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.name = this.internalGetName();
        builder.percentage = this.internalGetPercentage();
        builder.metadata = this.internalGetMetadata();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<String> name;
        private String type;
        private OptionalNullable<String> percentage;
        private OptionalNullable<Map<String, String>> metadata;
        private Money appliedMoney;
        private String scope;
        private Boolean autoApplied;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = OptionalNullable.of((Object)percentage);
            return this;
        }

        public Builder unsetPercentage() {
            this.percentage = null;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder autoApplied(Boolean autoApplied) {
            this.autoApplied = autoApplied;
            return this;
        }

        public OrderLineItemTax build() {
            return new OrderLineItemTax(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.metadata, this.appliedMoney, this.scope, this.autoApplied);
        }
    }
}

