/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderPricingOptions {
    private final OptionalNullable<Boolean> autoApplyDiscounts;
    private final OptionalNullable<Boolean> autoApplyTaxes;

    @JsonCreator
    public OrderPricingOptions(@JsonProperty(value="auto_apply_discounts") Boolean autoApplyDiscounts, @JsonProperty(value="auto_apply_taxes") Boolean autoApplyTaxes) {
        this.autoApplyDiscounts = OptionalNullable.of((Object)autoApplyDiscounts);
        this.autoApplyTaxes = OptionalNullable.of((Object)autoApplyTaxes);
    }

    protected OrderPricingOptions(OptionalNullable<Boolean> autoApplyDiscounts, OptionalNullable<Boolean> autoApplyTaxes) {
        this.autoApplyDiscounts = autoApplyDiscounts;
        this.autoApplyTaxes = autoApplyTaxes;
    }

    @JsonGetter(value="auto_apply_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAutoApplyDiscounts() {
        return this.autoApplyDiscounts;
    }

    @JsonIgnore
    public Boolean getAutoApplyDiscounts() {
        return (Boolean)OptionalNullable.getFrom(this.autoApplyDiscounts);
    }

    @JsonGetter(value="auto_apply_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAutoApplyTaxes() {
        return this.autoApplyTaxes;
    }

    @JsonIgnore
    public Boolean getAutoApplyTaxes() {
        return (Boolean)OptionalNullable.getFrom(this.autoApplyTaxes);
    }

    public int hashCode() {
        return Objects.hash(this.autoApplyDiscounts, this.autoApplyTaxes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderPricingOptions)) {
            return false;
        }
        OrderPricingOptions other = (OrderPricingOptions)obj;
        return Objects.equals(this.autoApplyDiscounts, other.autoApplyDiscounts) && Objects.equals(this.autoApplyTaxes, other.autoApplyTaxes);
    }

    public String toString() {
        return "OrderPricingOptions [autoApplyDiscounts=" + this.autoApplyDiscounts + ", autoApplyTaxes=" + this.autoApplyTaxes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.autoApplyDiscounts = this.internalGetAutoApplyDiscounts();
        builder.autoApplyTaxes = this.internalGetAutoApplyTaxes();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> autoApplyDiscounts;
        private OptionalNullable<Boolean> autoApplyTaxes;

        public Builder autoApplyDiscounts(Boolean autoApplyDiscounts) {
            this.autoApplyDiscounts = OptionalNullable.of((Object)autoApplyDiscounts);
            return this;
        }

        public Builder unsetAutoApplyDiscounts() {
            this.autoApplyDiscounts = null;
            return this;
        }

        public Builder autoApplyTaxes(Boolean autoApplyTaxes) {
            this.autoApplyTaxes = OptionalNullable.of((Object)autoApplyTaxes);
            return this;
        }

        public Builder unsetAutoApplyTaxes() {
            this.autoApplyTaxes = null;
            return this;
        }

        public OrderPricingOptions build() {
            return new OrderPricingOptions(this.autoApplyDiscounts, this.autoApplyTaxes);
        }
    }
}

