/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderMoneyAmounts;
import com.squareup.square.models.OrderReturnDiscount;
import com.squareup.square.models.OrderReturnLineItem;
import com.squareup.square.models.OrderReturnServiceCharge;
import com.squareup.square.models.OrderReturnTax;
import com.squareup.square.models.OrderRoundingAdjustment;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class OrderReturn {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> sourceOrderId;
    private final OptionalNullable<List<OrderReturnLineItem>> returnLineItems;
    private final List<OrderReturnServiceCharge> returnServiceCharges;
    private final OptionalNullable<List<OrderReturnTax>> returnTaxes;
    private final OptionalNullable<List<OrderReturnDiscount>> returnDiscounts;
    private final OrderRoundingAdjustment roundingAdjustment;
    private final OrderMoneyAmounts returnAmounts;

    @JsonCreator
    public OrderReturn(@JsonProperty(value="uid") String uid, @JsonProperty(value="source_order_id") String sourceOrderId, @JsonProperty(value="return_line_items") List<OrderReturnLineItem> returnLineItems, @JsonProperty(value="return_service_charges") List<OrderReturnServiceCharge> returnServiceCharges, @JsonProperty(value="return_taxes") List<OrderReturnTax> returnTaxes, @JsonProperty(value="return_discounts") List<OrderReturnDiscount> returnDiscounts, @JsonProperty(value="rounding_adjustment") OrderRoundingAdjustment roundingAdjustment, @JsonProperty(value="return_amounts") OrderMoneyAmounts returnAmounts) {
        this.uid = OptionalNullable.of((Object)uid);
        this.sourceOrderId = OptionalNullable.of((Object)sourceOrderId);
        this.returnLineItems = OptionalNullable.of(returnLineItems);
        this.returnServiceCharges = returnServiceCharges;
        this.returnTaxes = OptionalNullable.of(returnTaxes);
        this.returnDiscounts = OptionalNullable.of(returnDiscounts);
        this.roundingAdjustment = roundingAdjustment;
        this.returnAmounts = returnAmounts;
    }

    protected OrderReturn(OptionalNullable<String> uid, OptionalNullable<String> sourceOrderId, OptionalNullable<List<OrderReturnLineItem>> returnLineItems, List<OrderReturnServiceCharge> returnServiceCharges, OptionalNullable<List<OrderReturnTax>> returnTaxes, OptionalNullable<List<OrderReturnDiscount>> returnDiscounts, OrderRoundingAdjustment roundingAdjustment, OrderMoneyAmounts returnAmounts) {
        this.uid = uid;
        this.sourceOrderId = sourceOrderId;
        this.returnLineItems = returnLineItems;
        this.returnServiceCharges = returnServiceCharges;
        this.returnTaxes = returnTaxes;
        this.returnDiscounts = returnDiscounts;
        this.roundingAdjustment = roundingAdjustment;
        this.returnAmounts = returnAmounts;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="source_order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSourceOrderId() {
        return this.sourceOrderId;
    }

    @JsonIgnore
    public String getSourceOrderId() {
        return (String)OptionalNullable.getFrom(this.sourceOrderId);
    }

    @JsonGetter(value="return_line_items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderReturnLineItem>> internalGetReturnLineItems() {
        return this.returnLineItems;
    }

    @JsonIgnore
    public List<OrderReturnLineItem> getReturnLineItems() {
        return (List)OptionalNullable.getFrom(this.returnLineItems);
    }

    @JsonGetter(value="return_service_charges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnServiceCharge> getReturnServiceCharges() {
        return this.returnServiceCharges;
    }

    @JsonGetter(value="return_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderReturnTax>> internalGetReturnTaxes() {
        return this.returnTaxes;
    }

    @JsonIgnore
    public List<OrderReturnTax> getReturnTaxes() {
        return (List)OptionalNullable.getFrom(this.returnTaxes);
    }

    @JsonGetter(value="return_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderReturnDiscount>> internalGetReturnDiscounts() {
        return this.returnDiscounts;
    }

    @JsonIgnore
    public List<OrderReturnDiscount> getReturnDiscounts() {
        return (List)OptionalNullable.getFrom(this.returnDiscounts);
    }

    @JsonGetter(value="rounding_adjustment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderRoundingAdjustment getRoundingAdjustment() {
        return this.roundingAdjustment;
    }

    @JsonGetter(value="return_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderMoneyAmounts getReturnAmounts() {
        return this.returnAmounts;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.roundingAdjustment, this.returnAmounts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturn)) {
            return false;
        }
        OrderReturn other = (OrderReturn)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceOrderId, other.sourceOrderId) && Objects.equals(this.returnLineItems, other.returnLineItems) && Objects.equals(this.returnServiceCharges, other.returnServiceCharges) && Objects.equals(this.returnTaxes, other.returnTaxes) && Objects.equals(this.returnDiscounts, other.returnDiscounts) && Objects.equals(this.roundingAdjustment, other.roundingAdjustment) && Objects.equals(this.returnAmounts, other.returnAmounts);
    }

    public String toString() {
        return "OrderReturn [uid=" + this.uid + ", sourceOrderId=" + this.sourceOrderId + ", returnLineItems=" + this.returnLineItems + ", returnServiceCharges=" + this.returnServiceCharges + ", returnTaxes=" + this.returnTaxes + ", returnDiscounts=" + this.returnDiscounts + ", roundingAdjustment=" + this.roundingAdjustment + ", returnAmounts=" + this.returnAmounts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().returnServiceCharges(this.getReturnServiceCharges()).roundingAdjustment(this.getRoundingAdjustment()).returnAmounts(this.getReturnAmounts());
        builder.uid = this.internalGetUid();
        builder.sourceOrderId = this.internalGetSourceOrderId();
        builder.returnLineItems = this.internalGetReturnLineItems();
        builder.returnTaxes = this.internalGetReturnTaxes();
        builder.returnDiscounts = this.internalGetReturnDiscounts();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private OptionalNullable<String> sourceOrderId;
        private OptionalNullable<List<OrderReturnLineItem>> returnLineItems;
        private List<OrderReturnServiceCharge> returnServiceCharges;
        private OptionalNullable<List<OrderReturnTax>> returnTaxes;
        private OptionalNullable<List<OrderReturnDiscount>> returnDiscounts;
        private OrderRoundingAdjustment roundingAdjustment;
        private OrderMoneyAmounts returnAmounts;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder sourceOrderId(String sourceOrderId) {
            this.sourceOrderId = OptionalNullable.of((Object)sourceOrderId);
            return this;
        }

        public Builder unsetSourceOrderId() {
            this.sourceOrderId = null;
            return this;
        }

        public Builder returnLineItems(List<OrderReturnLineItem> returnLineItems) {
            this.returnLineItems = OptionalNullable.of(returnLineItems);
            return this;
        }

        public Builder unsetReturnLineItems() {
            this.returnLineItems = null;
            return this;
        }

        public Builder returnServiceCharges(List<OrderReturnServiceCharge> returnServiceCharges) {
            this.returnServiceCharges = returnServiceCharges;
            return this;
        }

        public Builder returnTaxes(List<OrderReturnTax> returnTaxes) {
            this.returnTaxes = OptionalNullable.of(returnTaxes);
            return this;
        }

        public Builder unsetReturnTaxes() {
            this.returnTaxes = null;
            return this;
        }

        public Builder returnDiscounts(List<OrderReturnDiscount> returnDiscounts) {
            this.returnDiscounts = OptionalNullable.of(returnDiscounts);
            return this;
        }

        public Builder unsetReturnDiscounts() {
            this.returnDiscounts = null;
            return this;
        }

        public Builder roundingAdjustment(OrderRoundingAdjustment roundingAdjustment) {
            this.roundingAdjustment = roundingAdjustment;
            return this;
        }

        public Builder returnAmounts(OrderMoneyAmounts returnAmounts) {
            this.returnAmounts = returnAmounts;
            return this;
        }

        public OrderReturn build() {
            return new OrderReturn(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.roundingAdjustment, this.returnAmounts);
        }
    }
}

