/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderRoundingAdjustment {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> name;
    private final Money amountMoney;

    @JsonCreator
    public OrderRoundingAdjustment(@JsonProperty(value="uid") String uid, @JsonProperty(value="name") String name, @JsonProperty(value="amount_money") Money amountMoney) {
        this.uid = OptionalNullable.of((Object)uid);
        this.name = OptionalNullable.of((Object)name);
        this.amountMoney = amountMoney;
    }

    protected OrderRoundingAdjustment(OptionalNullable<String> uid, OptionalNullable<String> name, Money amountMoney) {
        this.uid = uid;
        this.name = name;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderRoundingAdjustment)) {
            return false;
        }
        OrderRoundingAdjustment other = (OrderRoundingAdjustment)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.name, other.name) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "OrderRoundingAdjustment [uid=" + this.uid + ", name=" + this.name + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney());
        builder.uid = this.internalGetUid();
        builder.name = this.internalGetName();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private OptionalNullable<String> name;
        private Money amountMoney;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public OrderRoundingAdjustment build() {
            return new OrderRoundingAdjustment(this.uid, this.name, this.amountMoney);
        }
    }
}

