/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Subscription;
import com.squareup.square.models.SubscriptionAction;
import java.util.List;
import java.util.Objects;

public class PauseSubscriptionResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Subscription subscription;
    private final List<SubscriptionAction> actions;

    @JsonCreator
    public PauseSubscriptionResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="subscription") Subscription subscription, @JsonProperty(value="actions") List<SubscriptionAction> actions) {
        this.errors = errors;
        this.subscription = subscription;
        this.actions = actions;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="subscription")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Subscription getSubscription() {
        return this.subscription;
    }

    @JsonGetter(value="actions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SubscriptionAction> getActions() {
        return this.actions;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscription, this.actions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PauseSubscriptionResponse)) {
            return false;
        }
        PauseSubscriptionResponse other = (PauseSubscriptionResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.subscription, other.subscription) && Objects.equals(this.actions, other.actions);
    }

    public String toString() {
        return "PauseSubscriptionResponse [errors=" + this.errors + ", subscription=" + this.subscription + ", actions=" + this.actions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).subscription(this.getSubscription()).actions(this.getActions());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Subscription subscription;
        private List<SubscriptionAction> actions;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder actions(List<SubscriptionAction> actions) {
            this.actions = actions;
            return this;
        }

        public PauseSubscriptionResponse build() {
            PauseSubscriptionResponse model = new PauseSubscriptionResponse(this.errors, this.subscription, this.actions);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

