/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Order;
import java.util.List;
import java.util.Objects;

public class PayOrderResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Order order;

    @JsonCreator
    public PayOrderResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="order") Order order) {
        this.errors = errors;
        this.order = order;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PayOrderResponse)) {
            return false;
        }
        PayOrderResponse other = (PayOrderResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.order, other.order);
    }

    public String toString() {
        return "PayOrderResponse [errors=" + this.errors + ", order=" + this.order + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).order(this.getOrder());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Order order;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public PayOrderResponse build() {
            PayOrderResponse model = new PayOrderResponse(this.errors, this.order);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

