/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import com.squareup.square.models.ApplicationDetails;
import com.squareup.square.models.BankAccountPaymentDetails;
import com.squareup.square.models.BuyNowPayLaterDetails;
import com.squareup.square.models.CardPaymentDetails;
import com.squareup.square.models.CashPaymentDetails;
import com.squareup.square.models.DeviceDetails;
import com.squareup.square.models.DigitalWalletDetails;
import com.squareup.square.models.ExternalPaymentDetails;
import com.squareup.square.models.Money;
import com.squareup.square.models.ProcessingFee;
import com.squareup.square.models.RiskEvaluation;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Payment {
    private final String id;
    private final String createdAt;
    private final String updatedAt;
    private final Money amountMoney;
    private final Money tipMoney;
    private final Money totalMoney;
    private final Money appFeeMoney;
    private final Money approvedMoney;
    private final List<ProcessingFee> processingFee;
    private final Money refundedMoney;
    private final String status;
    private final String delayDuration;
    private final OptionalNullable<String> delayAction;
    private final String delayedUntil;
    private final String sourceType;
    private final CardPaymentDetails cardDetails;
    private final CashPaymentDetails cashDetails;
    private final BankAccountPaymentDetails bankAccountDetails;
    private final ExternalPaymentDetails externalDetails;
    private final DigitalWalletDetails walletDetails;
    private final BuyNowPayLaterDetails buyNowPayLaterDetails;
    private final String locationId;
    private final String orderId;
    private final String referenceId;
    private final String customerId;
    private final String employeeId;
    private final String teamMemberId;
    private final List<String> refundIds;
    private final RiskEvaluation riskEvaluation;
    private final String buyerEmailAddress;
    private final Address billingAddress;
    private final Address shippingAddress;
    private final String note;
    private final String statementDescriptionIdentifier;
    private final List<String> capabilities;
    private final String receiptNumber;
    private final String receiptUrl;
    private final DeviceDetails deviceDetails;
    private final ApplicationDetails applicationDetails;
    private final OptionalNullable<String> versionToken;

    @JsonCreator
    public Payment(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="tip_money") Money tipMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="approved_money") Money approvedMoney, @JsonProperty(value="processing_fee") List<ProcessingFee> processingFee, @JsonProperty(value="refunded_money") Money refundedMoney, @JsonProperty(value="status") String status, @JsonProperty(value="delay_duration") String delayDuration, @JsonProperty(value="delay_action") String delayAction, @JsonProperty(value="delayed_until") String delayedUntil, @JsonProperty(value="source_type") String sourceType, @JsonProperty(value="card_details") CardPaymentDetails cardDetails, @JsonProperty(value="cash_details") CashPaymentDetails cashDetails, @JsonProperty(value="bank_account_details") BankAccountPaymentDetails bankAccountDetails, @JsonProperty(value="external_details") ExternalPaymentDetails externalDetails, @JsonProperty(value="wallet_details") DigitalWalletDetails walletDetails, @JsonProperty(value="buy_now_pay_later_details") BuyNowPayLaterDetails buyNowPayLaterDetails, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="refund_ids") List<String> refundIds, @JsonProperty(value="risk_evaluation") RiskEvaluation riskEvaluation, @JsonProperty(value="buyer_email_address") String buyerEmailAddress, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="note") String note, @JsonProperty(value="statement_description_identifier") String statementDescriptionIdentifier, @JsonProperty(value="capabilities") List<String> capabilities, @JsonProperty(value="receipt_number") String receiptNumber, @JsonProperty(value="receipt_url") String receiptUrl, @JsonProperty(value="device_details") DeviceDetails deviceDetails, @JsonProperty(value="application_details") ApplicationDetails applicationDetails, @JsonProperty(value="version_token") String versionToken) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.totalMoney = totalMoney;
        this.appFeeMoney = appFeeMoney;
        this.approvedMoney = approvedMoney;
        this.processingFee = processingFee;
        this.refundedMoney = refundedMoney;
        this.status = status;
        this.delayDuration = delayDuration;
        this.delayAction = OptionalNullable.of((Object)delayAction);
        this.delayedUntil = delayedUntil;
        this.sourceType = sourceType;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.bankAccountDetails = bankAccountDetails;
        this.externalDetails = externalDetails;
        this.walletDetails = walletDetails;
        this.buyNowPayLaterDetails = buyNowPayLaterDetails;
        this.locationId = locationId;
        this.orderId = orderId;
        this.referenceId = referenceId;
        this.customerId = customerId;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
        this.refundIds = refundIds;
        this.riskEvaluation = riskEvaluation;
        this.buyerEmailAddress = buyerEmailAddress;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.note = note;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.capabilities = capabilities;
        this.receiptNumber = receiptNumber;
        this.receiptUrl = receiptUrl;
        this.deviceDetails = deviceDetails;
        this.applicationDetails = applicationDetails;
        this.versionToken = OptionalNullable.of((Object)versionToken);
    }

    protected Payment(String id, String createdAt, String updatedAt, Money amountMoney, Money tipMoney, Money totalMoney, Money appFeeMoney, Money approvedMoney, List<ProcessingFee> processingFee, Money refundedMoney, String status, String delayDuration, OptionalNullable<String> delayAction, String delayedUntil, String sourceType, CardPaymentDetails cardDetails, CashPaymentDetails cashDetails, BankAccountPaymentDetails bankAccountDetails, ExternalPaymentDetails externalDetails, DigitalWalletDetails walletDetails, BuyNowPayLaterDetails buyNowPayLaterDetails, String locationId, String orderId, String referenceId, String customerId, String employeeId, String teamMemberId, List<String> refundIds, RiskEvaluation riskEvaluation, String buyerEmailAddress, Address billingAddress, Address shippingAddress, String note, String statementDescriptionIdentifier, List<String> capabilities, String receiptNumber, String receiptUrl, DeviceDetails deviceDetails, ApplicationDetails applicationDetails, OptionalNullable<String> versionToken) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.totalMoney = totalMoney;
        this.appFeeMoney = appFeeMoney;
        this.approvedMoney = approvedMoney;
        this.processingFee = processingFee;
        this.refundedMoney = refundedMoney;
        this.status = status;
        this.delayDuration = delayDuration;
        this.delayAction = delayAction;
        this.delayedUntil = delayedUntil;
        this.sourceType = sourceType;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.bankAccountDetails = bankAccountDetails;
        this.externalDetails = externalDetails;
        this.walletDetails = walletDetails;
        this.buyNowPayLaterDetails = buyNowPayLaterDetails;
        this.locationId = locationId;
        this.orderId = orderId;
        this.referenceId = referenceId;
        this.customerId = customerId;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
        this.refundIds = refundIds;
        this.riskEvaluation = riskEvaluation;
        this.buyerEmailAddress = buyerEmailAddress;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.note = note;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.capabilities = capabilities;
        this.receiptNumber = receiptNumber;
        this.receiptUrl = receiptUrl;
        this.deviceDetails = deviceDetails;
        this.applicationDetails = applicationDetails;
        this.versionToken = versionToken;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="approved_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getApprovedMoney() {
        return this.approvedMoney;
    }

    @JsonGetter(value="processing_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ProcessingFee> getProcessingFee() {
        return this.processingFee;
    }

    @JsonGetter(value="refunded_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="delay_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDelayDuration() {
        return this.delayDuration;
    }

    @JsonGetter(value="delay_action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDelayAction() {
        return this.delayAction;
    }

    @JsonIgnore
    public String getDelayAction() {
        return (String)OptionalNullable.getFrom(this.delayAction);
    }

    @JsonGetter(value="delayed_until")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDelayedUntil() {
        return this.delayedUntil;
    }

    @JsonGetter(value="source_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceType() {
        return this.sourceType;
    }

    @JsonGetter(value="card_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardPaymentDetails getCardDetails() {
        return this.cardDetails;
    }

    @JsonGetter(value="cash_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CashPaymentDetails getCashDetails() {
        return this.cashDetails;
    }

    @JsonGetter(value="bank_account_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BankAccountPaymentDetails getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    @JsonGetter(value="external_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExternalPaymentDetails getExternalDetails() {
        return this.externalDetails;
    }

    @JsonGetter(value="wallet_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DigitalWalletDetails getWalletDetails() {
        return this.walletDetails;
    }

    @JsonGetter(value="buy_now_pay_later_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BuyNowPayLaterDetails getBuyNowPayLaterDetails() {
        return this.buyNowPayLaterDetails;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmployeeId() {
        return this.employeeId;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="refund_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getRefundIds() {
        return this.refundIds;
    }

    @JsonGetter(value="risk_evaluation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RiskEvaluation getRiskEvaluation() {
        return this.riskEvaluation;
    }

    @JsonGetter(value="buyer_email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="statement_description_identifier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatementDescriptionIdentifier() {
        return this.statementDescriptionIdentifier;
    }

    @JsonGetter(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    @JsonGetter(value="receipt_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @JsonGetter(value="receipt_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonGetter(value="device_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }

    @JsonGetter(value="application_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ApplicationDetails getApplicationDetails() {
        return this.applicationDetails;
    }

    @JsonGetter(value="version_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetVersionToken() {
        return this.versionToken;
    }

    @JsonIgnore
    public String getVersionToken() {
        return (String)OptionalNullable.getFrom(this.versionToken);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.amountMoney, this.tipMoney, this.totalMoney, this.appFeeMoney, this.approvedMoney, this.processingFee, this.refundedMoney, this.status, this.delayDuration, this.delayAction, this.delayedUntil, this.sourceType, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.externalDetails, this.walletDetails, this.buyNowPayLaterDetails, this.locationId, this.orderId, this.referenceId, this.customerId, this.employeeId, this.teamMemberId, this.refundIds, this.riskEvaluation, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.capabilities, this.receiptNumber, this.receiptUrl, this.deviceDetails, this.applicationDetails, this.versionToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.approvedMoney, other.approvedMoney) && Objects.equals(this.processingFee, other.processingFee) && Objects.equals(this.refundedMoney, other.refundedMoney) && Objects.equals(this.status, other.status) && Objects.equals(this.delayDuration, other.delayDuration) && Objects.equals(this.delayAction, other.delayAction) && Objects.equals(this.delayedUntil, other.delayedUntil) && Objects.equals(this.sourceType, other.sourceType) && Objects.equals(this.cardDetails, other.cardDetails) && Objects.equals(this.cashDetails, other.cashDetails) && Objects.equals(this.bankAccountDetails, other.bankAccountDetails) && Objects.equals(this.externalDetails, other.externalDetails) && Objects.equals(this.walletDetails, other.walletDetails) && Objects.equals(this.buyNowPayLaterDetails, other.buyNowPayLaterDetails) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.refundIds, other.refundIds) && Objects.equals(this.riskEvaluation, other.riskEvaluation) && Objects.equals(this.buyerEmailAddress, other.buyerEmailAddress) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.note, other.note) && Objects.equals(this.statementDescriptionIdentifier, other.statementDescriptionIdentifier) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.receiptNumber, other.receiptNumber) && Objects.equals(this.receiptUrl, other.receiptUrl) && Objects.equals(this.deviceDetails, other.deviceDetails) && Objects.equals(this.applicationDetails, other.applicationDetails) && Objects.equals(this.versionToken, other.versionToken);
    }

    public String toString() {
        return "Payment [id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", amountMoney=" + this.amountMoney + ", tipMoney=" + this.tipMoney + ", totalMoney=" + this.totalMoney + ", appFeeMoney=" + this.appFeeMoney + ", approvedMoney=" + this.approvedMoney + ", processingFee=" + this.processingFee + ", refundedMoney=" + this.refundedMoney + ", status=" + this.status + ", delayDuration=" + this.delayDuration + ", delayAction=" + this.delayAction + ", delayedUntil=" + this.delayedUntil + ", sourceType=" + this.sourceType + ", cardDetails=" + this.cardDetails + ", cashDetails=" + this.cashDetails + ", bankAccountDetails=" + this.bankAccountDetails + ", externalDetails=" + this.externalDetails + ", walletDetails=" + this.walletDetails + ", buyNowPayLaterDetails=" + this.buyNowPayLaterDetails + ", locationId=" + this.locationId + ", orderId=" + this.orderId + ", referenceId=" + this.referenceId + ", customerId=" + this.customerId + ", employeeId=" + this.employeeId + ", teamMemberId=" + this.teamMemberId + ", refundIds=" + this.refundIds + ", riskEvaluation=" + this.riskEvaluation + ", buyerEmailAddress=" + this.buyerEmailAddress + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", note=" + this.note + ", statementDescriptionIdentifier=" + this.statementDescriptionIdentifier + ", capabilities=" + this.capabilities + ", receiptNumber=" + this.receiptNumber + ", receiptUrl=" + this.receiptUrl + ", deviceDetails=" + this.deviceDetails + ", applicationDetails=" + this.applicationDetails + ", versionToken=" + this.versionToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).amountMoney(this.getAmountMoney()).tipMoney(this.getTipMoney()).totalMoney(this.getTotalMoney()).appFeeMoney(this.getAppFeeMoney()).approvedMoney(this.getApprovedMoney()).processingFee(this.getProcessingFee()).refundedMoney(this.getRefundedMoney()).status(this.getStatus()).delayDuration(this.getDelayDuration()).delayedUntil(this.getDelayedUntil()).sourceType(this.getSourceType()).cardDetails(this.getCardDetails()).cashDetails(this.getCashDetails()).bankAccountDetails(this.getBankAccountDetails()).externalDetails(this.getExternalDetails()).walletDetails(this.getWalletDetails()).buyNowPayLaterDetails(this.getBuyNowPayLaterDetails()).locationId(this.getLocationId()).orderId(this.getOrderId()).referenceId(this.getReferenceId()).customerId(this.getCustomerId()).employeeId(this.getEmployeeId()).teamMemberId(this.getTeamMemberId()).refundIds(this.getRefundIds()).riskEvaluation(this.getRiskEvaluation()).buyerEmailAddress(this.getBuyerEmailAddress()).billingAddress(this.getBillingAddress()).shippingAddress(this.getShippingAddress()).note(this.getNote()).statementDescriptionIdentifier(this.getStatementDescriptionIdentifier()).capabilities(this.getCapabilities()).receiptNumber(this.getReceiptNumber()).receiptUrl(this.getReceiptUrl()).deviceDetails(this.getDeviceDetails()).applicationDetails(this.getApplicationDetails());
        builder.delayAction = this.internalGetDelayAction();
        builder.versionToken = this.internalGetVersionToken();
        return builder;
    }

    public static class Builder {
        private String id;
        private String createdAt;
        private String updatedAt;
        private Money amountMoney;
        private Money tipMoney;
        private Money totalMoney;
        private Money appFeeMoney;
        private Money approvedMoney;
        private List<ProcessingFee> processingFee;
        private Money refundedMoney;
        private String status;
        private String delayDuration;
        private OptionalNullable<String> delayAction;
        private String delayedUntil;
        private String sourceType;
        private CardPaymentDetails cardDetails;
        private CashPaymentDetails cashDetails;
        private BankAccountPaymentDetails bankAccountDetails;
        private ExternalPaymentDetails externalDetails;
        private DigitalWalletDetails walletDetails;
        private BuyNowPayLaterDetails buyNowPayLaterDetails;
        private String locationId;
        private String orderId;
        private String referenceId;
        private String customerId;
        private String employeeId;
        private String teamMemberId;
        private List<String> refundIds;
        private RiskEvaluation riskEvaluation;
        private String buyerEmailAddress;
        private Address billingAddress;
        private Address shippingAddress;
        private String note;
        private String statementDescriptionIdentifier;
        private List<String> capabilities;
        private String receiptNumber;
        private String receiptUrl;
        private DeviceDetails deviceDetails;
        private ApplicationDetails applicationDetails;
        private OptionalNullable<String> versionToken;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder approvedMoney(Money approvedMoney) {
            this.approvedMoney = approvedMoney;
            return this;
        }

        public Builder processingFee(List<ProcessingFee> processingFee) {
            this.processingFee = processingFee;
            return this;
        }

        public Builder refundedMoney(Money refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        public Builder delayAction(String delayAction) {
            this.delayAction = OptionalNullable.of((Object)delayAction);
            return this;
        }

        public Builder unsetDelayAction() {
            this.delayAction = null;
            return this;
        }

        public Builder delayedUntil(String delayedUntil) {
            this.delayedUntil = delayedUntil;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder cardDetails(CardPaymentDetails cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public Builder cashDetails(CashPaymentDetails cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder bankAccountDetails(BankAccountPaymentDetails bankAccountDetails) {
            this.bankAccountDetails = bankAccountDetails;
            return this;
        }

        public Builder externalDetails(ExternalPaymentDetails externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        public Builder walletDetails(DigitalWalletDetails walletDetails) {
            this.walletDetails = walletDetails;
            return this;
        }

        public Builder buyNowPayLaterDetails(BuyNowPayLaterDetails buyNowPayLaterDetails) {
            this.buyNowPayLaterDetails = buyNowPayLaterDetails;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder refundIds(List<String> refundIds) {
            this.refundIds = refundIds;
            return this;
        }

        public Builder riskEvaluation(RiskEvaluation riskEvaluation) {
            this.riskEvaluation = riskEvaluation;
            return this;
        }

        public Builder buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = buyerEmailAddress;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder statementDescriptionIdentifier(String statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier;
            return this;
        }

        public Builder capabilities(List<String> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder receiptNumber(String receiptNumber) {
            this.receiptNumber = receiptNumber;
            return this;
        }

        public Builder receiptUrl(String receiptUrl) {
            this.receiptUrl = receiptUrl;
            return this;
        }

        public Builder deviceDetails(DeviceDetails deviceDetails) {
            this.deviceDetails = deviceDetails;
            return this;
        }

        public Builder applicationDetails(ApplicationDetails applicationDetails) {
            this.applicationDetails = applicationDetails;
            return this;
        }

        public Builder versionToken(String versionToken) {
            this.versionToken = OptionalNullable.of((Object)versionToken);
            return this;
        }

        public Builder unsetVersionToken() {
            this.versionToken = null;
            return this;
        }

        public Payment build() {
            return new Payment(this.id, this.createdAt, this.updatedAt, this.amountMoney, this.tipMoney, this.totalMoney, this.appFeeMoney, this.approvedMoney, this.processingFee, this.refundedMoney, this.status, this.delayDuration, this.delayAction, this.delayedUntil, this.sourceType, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.externalDetails, this.walletDetails, this.buyNowPayLaterDetails, this.locationId, this.orderId, this.referenceId, this.customerId, this.employeeId, this.teamMemberId, this.refundIds, this.riskEvaluation, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.capabilities, this.receiptNumber, this.receiptUrl, this.deviceDetails, this.applicationDetails, this.versionToken);
        }
    }
}

