/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaymentBalanceActivityRefundDetail {
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> refundId;

    @JsonCreator
    public PaymentBalanceActivityRefundDetail(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="refund_id") String refundId) {
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.refundId = OptionalNullable.of((Object)refundId);
    }

    protected PaymentBalanceActivityRefundDetail(OptionalNullable<String> paymentId, OptionalNullable<String> refundId) {
        this.paymentId = paymentId;
        this.refundId = refundId;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="refund_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRefundId() {
        return this.refundId;
    }

    @JsonIgnore
    public String getRefundId() {
        return (String)OptionalNullable.getFrom(this.refundId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.refundId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentBalanceActivityRefundDetail)) {
            return false;
        }
        PaymentBalanceActivityRefundDetail other = (PaymentBalanceActivityRefundDetail)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.refundId, other.refundId);
    }

    public String toString() {
        return "PaymentBalanceActivityRefundDetail [paymentId=" + this.paymentId + ", refundId=" + this.refundId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.paymentId = this.internalGetPaymentId();
        builder.refundId = this.internalGetRefundId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> refundId;

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder refundId(String refundId) {
            this.refundId = OptionalNullable.of((Object)refundId);
            return this;
        }

        public Builder unsetRefundId() {
            this.refundId = null;
            return this;
        }

        public PaymentBalanceActivityRefundDetail build() {
            return new PaymentBalanceActivityRefundDetail(this.paymentId, this.refundId);
        }
    }
}

