/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaymentBalanceActivityTaxOnFeeDetail {
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> taxRateDescription;

    @JsonCreator
    public PaymentBalanceActivityTaxOnFeeDetail(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="tax_rate_description") String taxRateDescription) {
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.taxRateDescription = OptionalNullable.of((Object)taxRateDescription);
    }

    protected PaymentBalanceActivityTaxOnFeeDetail(OptionalNullable<String> paymentId, OptionalNullable<String> taxRateDescription) {
        this.paymentId = paymentId;
        this.taxRateDescription = taxRateDescription;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="tax_rate_description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTaxRateDescription() {
        return this.taxRateDescription;
    }

    @JsonIgnore
    public String getTaxRateDescription() {
        return (String)OptionalNullable.getFrom(this.taxRateDescription);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.taxRateDescription);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentBalanceActivityTaxOnFeeDetail)) {
            return false;
        }
        PaymentBalanceActivityTaxOnFeeDetail other = (PaymentBalanceActivityTaxOnFeeDetail)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.taxRateDescription, other.taxRateDescription);
    }

    public String toString() {
        return "PaymentBalanceActivityTaxOnFeeDetail [paymentId=" + this.paymentId + ", taxRateDescription=" + this.taxRateDescription + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.paymentId = this.internalGetPaymentId();
        builder.taxRateDescription = this.internalGetTaxRateDescription();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> taxRateDescription;

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder taxRateDescription(String taxRateDescription) {
            this.taxRateDescription = OptionalNullable.of((Object)taxRateDescription);
            return this;
        }

        public Builder unsetTaxRateDescription() {
            this.taxRateDescription = null;
            return this;
        }

        public PaymentBalanceActivityTaxOnFeeDetail build() {
            return new PaymentBalanceActivityTaxOnFeeDetail(this.paymentId, this.taxRateDescription);
        }
    }
}

