/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PhaseInput {
    private final int ordinal;
    private final OptionalNullable<String> orderTemplateId;

    @JsonCreator
    public PhaseInput(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="order_template_id") String orderTemplateId) {
        this.ordinal = ordinal;
        this.orderTemplateId = OptionalNullable.of((Object)orderTemplateId);
    }

    protected PhaseInput(int ordinal, OptionalNullable<String> orderTemplateId) {
        this.ordinal = ordinal;
        this.orderTemplateId = orderTemplateId;
    }

    @JsonGetter(value="ordinal")
    public int getOrdinal() {
        return this.ordinal;
    }

    @JsonGetter(value="order_template_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderTemplateId() {
        return this.orderTemplateId;
    }

    @JsonIgnore
    public String getOrderTemplateId() {
        return (String)OptionalNullable.getFrom(this.orderTemplateId);
    }

    public int hashCode() {
        return Objects.hash(this.ordinal, this.orderTemplateId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PhaseInput)) {
            return false;
        }
        PhaseInput other = (PhaseInput)obj;
        return Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.orderTemplateId, other.orderTemplateId);
    }

    public String toString() {
        return "PhaseInput [ordinal=" + this.ordinal + ", orderTemplateId=" + this.orderTemplateId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.ordinal);
        builder.orderTemplateId = this.internalGetOrderTemplateId();
        return builder;
    }

    public static class Builder {
        private int ordinal;
        private OptionalNullable<String> orderTemplateId;

        public Builder(int ordinal) {
            this.ordinal = ordinal;
        }

        public Builder ordinal(int ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder orderTemplateId(String orderTemplateId) {
            this.orderTemplateId = OptionalNullable.of((Object)orderTemplateId);
            return this;
        }

        public Builder unsetOrderTemplateId() {
            this.orderTemplateId = null;
            return this;
        }

        public PhaseInput build() {
            return new PhaseInput(this.ordinal, this.orderTemplateId);
        }
    }
}

