/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PrePopulatedData {
    private final OptionalNullable<String> buyerEmail;
    private final OptionalNullable<String> buyerPhoneNumber;
    private final Address buyerAddress;

    @JsonCreator
    public PrePopulatedData(@JsonProperty(value="buyer_email") String buyerEmail, @JsonProperty(value="buyer_phone_number") String buyerPhoneNumber, @JsonProperty(value="buyer_address") Address buyerAddress) {
        this.buyerEmail = OptionalNullable.of((Object)buyerEmail);
        this.buyerPhoneNumber = OptionalNullable.of((Object)buyerPhoneNumber);
        this.buyerAddress = buyerAddress;
    }

    protected PrePopulatedData(OptionalNullable<String> buyerEmail, OptionalNullable<String> buyerPhoneNumber, Address buyerAddress) {
        this.buyerEmail = buyerEmail;
        this.buyerPhoneNumber = buyerPhoneNumber;
        this.buyerAddress = buyerAddress;
    }

    @JsonGetter(value="buyer_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerEmail() {
        return this.buyerEmail;
    }

    @JsonIgnore
    public String getBuyerEmail() {
        return (String)OptionalNullable.getFrom(this.buyerEmail);
    }

    @JsonGetter(value="buyer_phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerPhoneNumber() {
        return this.buyerPhoneNumber;
    }

    @JsonIgnore
    public String getBuyerPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.buyerPhoneNumber);
    }

    @JsonGetter(value="buyer_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBuyerAddress() {
        return this.buyerAddress;
    }

    public int hashCode() {
        return Objects.hash(this.buyerEmail, this.buyerPhoneNumber, this.buyerAddress);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrePopulatedData)) {
            return false;
        }
        PrePopulatedData other = (PrePopulatedData)obj;
        return Objects.equals(this.buyerEmail, other.buyerEmail) && Objects.equals(this.buyerPhoneNumber, other.buyerPhoneNumber) && Objects.equals(this.buyerAddress, other.buyerAddress);
    }

    public String toString() {
        return "PrePopulatedData [buyerEmail=" + this.buyerEmail + ", buyerPhoneNumber=" + this.buyerPhoneNumber + ", buyerAddress=" + this.buyerAddress + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().buyerAddress(this.getBuyerAddress());
        builder.buyerEmail = this.internalGetBuyerEmail();
        builder.buyerPhoneNumber = this.internalGetBuyerPhoneNumber();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> buyerEmail;
        private OptionalNullable<String> buyerPhoneNumber;
        private Address buyerAddress;

        public Builder buyerEmail(String buyerEmail) {
            this.buyerEmail = OptionalNullable.of((Object)buyerEmail);
            return this;
        }

        public Builder unsetBuyerEmail() {
            this.buyerEmail = null;
            return this;
        }

        public Builder buyerPhoneNumber(String buyerPhoneNumber) {
            this.buyerPhoneNumber = OptionalNullable.of((Object)buyerPhoneNumber);
            return this;
        }

        public Builder unsetBuyerPhoneNumber() {
            this.buyerPhoneNumber = null;
            return this;
        }

        public Builder buyerAddress(Address buyerAddress) {
            this.buyerAddress = buyerAddress;
            return this;
        }

        public PrePopulatedData build() {
            return new PrePopulatedData(this.buyerEmail, this.buyerPhoneNumber, this.buyerAddress);
        }
    }
}

