/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class QuantityRatio {
    private final OptionalNullable<Integer> quantity;
    private final OptionalNullable<Integer> quantityDenominator;

    @JsonCreator
    public QuantityRatio(@JsonProperty(value="quantity") Integer quantity, @JsonProperty(value="quantity_denominator") Integer quantityDenominator) {
        this.quantity = OptionalNullable.of((Object)quantity);
        this.quantityDenominator = OptionalNullable.of((Object)quantityDenominator);
    }

    protected QuantityRatio(OptionalNullable<Integer> quantity, OptionalNullable<Integer> quantityDenominator) {
        this.quantity = quantity;
        this.quantityDenominator = quantityDenominator;
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetQuantity() {
        return this.quantity;
    }

    @JsonIgnore
    public Integer getQuantity() {
        return (Integer)OptionalNullable.getFrom(this.quantity);
    }

    @JsonGetter(value="quantity_denominator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetQuantityDenominator() {
        return this.quantityDenominator;
    }

    @JsonIgnore
    public Integer getQuantityDenominator() {
        return (Integer)OptionalNullable.getFrom(this.quantityDenominator);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.quantityDenominator);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QuantityRatio)) {
            return false;
        }
        QuantityRatio other = (QuantityRatio)obj;
        return Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityDenominator, other.quantityDenominator);
    }

    public String toString() {
        return "QuantityRatio [quantity=" + this.quantity + ", quantityDenominator=" + this.quantityDenominator + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.quantity = this.internalGetQuantity();
        builder.quantityDenominator = this.internalGetQuantityDenominator();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Integer> quantity;
        private OptionalNullable<Integer> quantityDenominator;

        public Builder quantity(Integer quantity) {
            this.quantity = OptionalNullable.of((Object)quantity);
            return this;
        }

        public Builder unsetQuantity() {
            this.quantity = null;
            return this;
        }

        public Builder quantityDenominator(Integer quantityDenominator) {
            this.quantityDenominator = OptionalNullable.of((Object)quantityDenominator);
            return this;
        }

        public Builder unsetQuantityDenominator() {
            this.quantityDenominator = null;
            return this;
        }

        public QuantityRatio build() {
            return new QuantityRatio(this.quantity, this.quantityDenominator);
        }
    }
}

