/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Range {
    private final OptionalNullable<String> min;
    private final OptionalNullable<String> max;

    @JsonCreator
    public Range(@JsonProperty(value="min") String min, @JsonProperty(value="max") String max) {
        this.min = OptionalNullable.of((Object)min);
        this.max = OptionalNullable.of((Object)max);
    }

    protected Range(OptionalNullable<String> min, OptionalNullable<String> max) {
        this.min = min;
        this.max = max;
    }

    @JsonGetter(value="min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMin() {
        return this.min;
    }

    @JsonIgnore
    public String getMin() {
        return (String)OptionalNullable.getFrom(this.min);
    }

    @JsonGetter(value="max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMax() {
        return this.max;
    }

    @JsonIgnore
    public String getMax() {
        return (String)OptionalNullable.getFrom(this.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }

    public String toString() {
        return "Range [min=" + this.min + ", max=" + this.max + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.min = this.internalGetMin();
        builder.max = this.internalGetMax();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> min;
        private OptionalNullable<String> max;

        public Builder min(String min) {
            this.min = OptionalNullable.of((Object)min);
            return this;
        }

        public Builder unsetMin() {
            this.min = null;
            return this;
        }

        public Builder max(String max) {
            this.max = OptionalNullable.of((Object)max);
            return this;
        }

        public Builder unsetMax() {
            this.max = null;
            return this;
        }

        public Range build() {
            return new Range(this.min, this.max);
        }
    }
}

