/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ReceiptOptions {
    private final String paymentId;
    private final OptionalNullable<Boolean> printOnly;
    private final OptionalNullable<Boolean> isDuplicate;

    @JsonCreator
    public ReceiptOptions(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="print_only") Boolean printOnly, @JsonProperty(value="is_duplicate") Boolean isDuplicate) {
        this.paymentId = paymentId;
        this.printOnly = OptionalNullable.of((Object)printOnly);
        this.isDuplicate = OptionalNullable.of((Object)isDuplicate);
    }

    protected ReceiptOptions(String paymentId, OptionalNullable<Boolean> printOnly, OptionalNullable<Boolean> isDuplicate) {
        this.paymentId = paymentId;
        this.printOnly = printOnly;
        this.isDuplicate = isDuplicate;
    }

    @JsonGetter(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="print_only")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetPrintOnly() {
        return this.printOnly;
    }

    @JsonIgnore
    public Boolean getPrintOnly() {
        return (Boolean)OptionalNullable.getFrom(this.printOnly);
    }

    @JsonGetter(value="is_duplicate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsDuplicate() {
        return this.isDuplicate;
    }

    @JsonIgnore
    public Boolean getIsDuplicate() {
        return (Boolean)OptionalNullable.getFrom(this.isDuplicate);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.printOnly, this.isDuplicate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReceiptOptions)) {
            return false;
        }
        ReceiptOptions other = (ReceiptOptions)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.printOnly, other.printOnly) && Objects.equals(this.isDuplicate, other.isDuplicate);
    }

    public String toString() {
        return "ReceiptOptions [paymentId=" + this.paymentId + ", printOnly=" + this.printOnly + ", isDuplicate=" + this.isDuplicate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentId);
        builder.printOnly = this.internalGetPrintOnly();
        builder.isDuplicate = this.internalGetIsDuplicate();
        return builder;
    }

    public static class Builder {
        private String paymentId;
        private OptionalNullable<Boolean> printOnly;
        private OptionalNullable<Boolean> isDuplicate;

        public Builder(String paymentId) {
            this.paymentId = paymentId;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder printOnly(Boolean printOnly) {
            this.printOnly = OptionalNullable.of((Object)printOnly);
            return this;
        }

        public Builder unsetPrintOnly() {
            this.printOnly = null;
            return this;
        }

        public Builder isDuplicate(Boolean isDuplicate) {
            this.isDuplicate = OptionalNullable.of((Object)isDuplicate);
            return this;
        }

        public Builder unsetIsDuplicate() {
            this.isDuplicate = null;
            return this;
        }

        public ReceiptOptions build() {
            return new ReceiptOptions(this.paymentId, this.printOnly, this.isDuplicate);
        }
    }
}

