/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class RefundPaymentRequest {
    private final String idempotencyKey;
    private final Money amountMoney;
    private final Money appFeeMoney;
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> destinationId;
    private final OptionalNullable<Boolean> unlinked;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> customerId;
    private final OptionalNullable<String> reason;
    private final OptionalNullable<String> paymentVersionToken;
    private final OptionalNullable<String> teamMemberId;

    @JsonCreator
    public RefundPaymentRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="destination_id") String destinationId, @JsonProperty(value="unlinked") Boolean unlinked, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="reason") String reason, @JsonProperty(value="payment_version_token") String paymentVersionToken, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.destinationId = OptionalNullable.of((Object)destinationId);
        this.unlinked = OptionalNullable.of((Object)unlinked);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.customerId = OptionalNullable.of((Object)customerId);
        this.reason = OptionalNullable.of((Object)reason);
        this.paymentVersionToken = OptionalNullable.of((Object)paymentVersionToken);
        this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
    }

    protected RefundPaymentRequest(String idempotencyKey, Money amountMoney, Money appFeeMoney, OptionalNullable<String> paymentId, OptionalNullable<String> destinationId, OptionalNullable<Boolean> unlinked, OptionalNullable<String> locationId, OptionalNullable<String> customerId, OptionalNullable<String> reason, OptionalNullable<String> paymentVersionToken, OptionalNullable<String> teamMemberId) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.paymentId = paymentId;
        this.destinationId = destinationId;
        this.unlinked = unlinked;
        this.locationId = locationId;
        this.customerId = customerId;
        this.reason = reason;
        this.paymentVersionToken = paymentVersionToken;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="destination_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDestinationId() {
        return this.destinationId;
    }

    @JsonIgnore
    public String getDestinationId() {
        return (String)OptionalNullable.getFrom(this.destinationId);
    }

    @JsonGetter(value="unlinked")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetUnlinked() {
        return this.unlinked;
    }

    @JsonIgnore
    public Boolean getUnlinked() {
        return (Boolean)OptionalNullable.getFrom(this.unlinked);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReason() {
        return this.reason;
    }

    @JsonIgnore
    public String getReason() {
        return (String)OptionalNullable.getFrom(this.reason);
    }

    @JsonGetter(value="payment_version_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentVersionToken() {
        return this.paymentVersionToken;
    }

    @JsonIgnore
    public String getPaymentVersionToken() {
        return (String)OptionalNullable.getFrom(this.paymentVersionToken);
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonIgnore
    public String getTeamMemberId() {
        return (String)OptionalNullable.getFrom(this.teamMemberId);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.destinationId, this.unlinked, this.locationId, this.customerId, this.reason, this.paymentVersionToken, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RefundPaymentRequest)) {
            return false;
        }
        RefundPaymentRequest other = (RefundPaymentRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.destinationId, other.destinationId) && Objects.equals(this.unlinked, other.unlinked) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.reason, other.reason) && Objects.equals(this.paymentVersionToken, other.paymentVersionToken) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "RefundPaymentRequest [idempotencyKey=" + this.idempotencyKey + ", amountMoney=" + this.amountMoney + ", appFeeMoney=" + this.appFeeMoney + ", paymentId=" + this.paymentId + ", destinationId=" + this.destinationId + ", unlinked=" + this.unlinked + ", locationId=" + this.locationId + ", customerId=" + this.customerId + ", reason=" + this.reason + ", paymentVersionToken=" + this.paymentVersionToken + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.amountMoney).appFeeMoney(this.getAppFeeMoney());
        builder.paymentId = this.internalGetPaymentId();
        builder.destinationId = this.internalGetDestinationId();
        builder.unlinked = this.internalGetUnlinked();
        builder.locationId = this.internalGetLocationId();
        builder.customerId = this.internalGetCustomerId();
        builder.reason = this.internalGetReason();
        builder.paymentVersionToken = this.internalGetPaymentVersionToken();
        builder.teamMemberId = this.internalGetTeamMemberId();
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Money amountMoney;
        private Money appFeeMoney;
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> destinationId;
        private OptionalNullable<Boolean> unlinked;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> customerId;
        private OptionalNullable<String> reason;
        private OptionalNullable<String> paymentVersionToken;
        private OptionalNullable<String> teamMemberId;

        public Builder(String idempotencyKey, Money amountMoney) {
            this.idempotencyKey = idempotencyKey;
            this.amountMoney = amountMoney;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder destinationId(String destinationId) {
            this.destinationId = OptionalNullable.of((Object)destinationId);
            return this;
        }

        public Builder unsetDestinationId() {
            this.destinationId = null;
            return this;
        }

        public Builder unlinked(Boolean unlinked) {
            this.unlinked = OptionalNullable.of((Object)unlinked);
            return this;
        }

        public Builder unsetUnlinked() {
            this.unlinked = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = OptionalNullable.of((Object)reason);
            return this;
        }

        public Builder unsetReason() {
            this.reason = null;
            return this;
        }

        public Builder paymentVersionToken(String paymentVersionToken) {
            this.paymentVersionToken = OptionalNullable.of((Object)paymentVersionToken);
            return this;
        }

        public Builder unsetPaymentVersionToken() {
            this.paymentVersionToken = null;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
            return this;
        }

        public Builder unsetTeamMemberId() {
            this.teamMemberId = null;
            return this;
        }

        public RefundPaymentRequest build() {
            return new RefundPaymentRequest(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.destinationId, this.unlinked, this.locationId, this.customerId, this.reason, this.paymentVersionToken, this.teamMemberId);
        }
    }
}

