/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomAttributeDefinition;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveBookingCustomAttributeDefinitionResponse {
    private HttpContext httpContext;
    private final CustomAttributeDefinition customAttributeDefinition;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveBookingCustomAttributeDefinitionResponse(@JsonProperty(value="custom_attribute_definition") CustomAttributeDefinition customAttributeDefinition, @JsonProperty(value="errors") List<Error> errors) {
        this.customAttributeDefinition = customAttributeDefinition;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="custom_attribute_definition")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomAttributeDefinition getCustomAttributeDefinition() {
        return this.customAttributeDefinition;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.customAttributeDefinition, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveBookingCustomAttributeDefinitionResponse)) {
            return false;
        }
        RetrieveBookingCustomAttributeDefinitionResponse other = (RetrieveBookingCustomAttributeDefinitionResponse)obj;
        return Objects.equals(this.customAttributeDefinition, other.customAttributeDefinition) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveBookingCustomAttributeDefinitionResponse [customAttributeDefinition=" + this.customAttributeDefinition + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customAttributeDefinition(this.getCustomAttributeDefinition()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private CustomAttributeDefinition customAttributeDefinition;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder customAttributeDefinition(CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = customAttributeDefinition;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveBookingCustomAttributeDefinitionResponse build() {
            RetrieveBookingCustomAttributeDefinitionResponse model = new RetrieveBookingCustomAttributeDefinitionResponse(this.customAttributeDefinition, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

