/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomerSegment;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveCustomerSegmentResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CustomerSegment segment;

    @JsonCreator
    public RetrieveCustomerSegmentResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="segment") CustomerSegment segment) {
        this.errors = errors;
        this.segment = segment;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="segment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerSegment getSegment() {
        return this.segment;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.segment);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveCustomerSegmentResponse)) {
            return false;
        }
        RetrieveCustomerSegmentResponse other = (RetrieveCustomerSegmentResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.segment, other.segment);
    }

    public String toString() {
        return "RetrieveCustomerSegmentResponse [errors=" + this.errors + ", segment=" + this.segment + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).segment(this.getSegment());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CustomerSegment segment;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder segment(CustomerSegment segment) {
            this.segment = segment;
            return this;
        }

        public RetrieveCustomerSegmentResponse build() {
            RetrieveCustomerSegmentResponse model = new RetrieveCustomerSegmentResponse(this.errors, this.segment);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

