/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryChange;
import java.util.List;
import java.util.Objects;

public class RetrieveInventoryChangesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<InventoryChange> changes;
    private final String cursor;

    @JsonCreator
    public RetrieveInventoryChangesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="changes") List<InventoryChange> changes, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.changes = changes;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="changes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InventoryChange> getChanges() {
        return this.changes;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.changes, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryChangesResponse)) {
            return false;
        }
        RetrieveInventoryChangesResponse other = (RetrieveInventoryChangesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.changes, other.changes) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "RetrieveInventoryChangesResponse [errors=" + this.errors + ", changes=" + this.changes + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).changes(this.getChanges()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<InventoryChange> changes;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder changes(List<InventoryChange> changes) {
            this.changes = changes;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public RetrieveInventoryChangesResponse build() {
            RetrieveInventoryChangesResponse model = new RetrieveInventoryChangesResponse(this.errors, this.changes, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

