/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryTransfer;
import java.util.List;
import java.util.Objects;

public class RetrieveInventoryTransferResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final InventoryTransfer transfer;

    @JsonCreator
    public RetrieveInventoryTransferResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="transfer") InventoryTransfer transfer) {
        this.errors = errors;
        this.transfer = transfer;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="transfer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryTransfer getTransfer() {
        return this.transfer;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transfer);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryTransferResponse)) {
            return false;
        }
        RetrieveInventoryTransferResponse other = (RetrieveInventoryTransferResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.transfer, other.transfer);
    }

    public String toString() {
        return "RetrieveInventoryTransferResponse [errors=" + this.errors + ", transfer=" + this.transfer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).transfer(this.getTransfer());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private InventoryTransfer transfer;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder transfer(InventoryTransfer transfer) {
            this.transfer = transfer;
            return this;
        }

        public RetrieveInventoryTransferResponse build() {
            RetrieveInventoryTransferResponse model = new RetrieveInventoryTransferResponse(this.errors, this.transfer);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

