/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyPromotion;
import java.util.List;
import java.util.Objects;

public class RetrieveLoyaltyPromotionResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final LoyaltyPromotion loyaltyPromotion;

    @JsonCreator
    public RetrieveLoyaltyPromotionResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="loyalty_promotion") LoyaltyPromotion loyaltyPromotion) {
        this.errors = errors;
        this.loyaltyPromotion = loyaltyPromotion;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="loyalty_promotion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyPromotion getLoyaltyPromotion() {
        return this.loyaltyPromotion;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyPromotion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveLoyaltyPromotionResponse)) {
            return false;
        }
        RetrieveLoyaltyPromotionResponse other = (RetrieveLoyaltyPromotionResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.loyaltyPromotion, other.loyaltyPromotion);
    }

    public String toString() {
        return "RetrieveLoyaltyPromotionResponse [errors=" + this.errors + ", loyaltyPromotion=" + this.loyaltyPromotion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).loyaltyPromotion(this.getLoyaltyPromotion());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private LoyaltyPromotion loyaltyPromotion;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder loyaltyPromotion(LoyaltyPromotion loyaltyPromotion) {
            this.loyaltyPromotion = loyaltyPromotion;
            return this;
        }

        public RetrieveLoyaltyPromotionResponse build() {
            RetrieveLoyaltyPromotionResponse model = new RetrieveLoyaltyPromotionResponse(this.errors, this.loyaltyPromotion);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

