/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyReward;
import java.util.List;
import java.util.Objects;

public class RetrieveLoyaltyRewardResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final LoyaltyReward reward;

    @JsonCreator
    public RetrieveLoyaltyRewardResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="reward") LoyaltyReward reward) {
        this.errors = errors;
        this.reward = reward;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="reward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyReward getReward() {
        return this.reward;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.reward);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveLoyaltyRewardResponse)) {
            return false;
        }
        RetrieveLoyaltyRewardResponse other = (RetrieveLoyaltyRewardResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.reward, other.reward);
    }

    public String toString() {
        return "RetrieveLoyaltyRewardResponse [errors=" + this.errors + ", reward=" + this.reward + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).reward(this.getReward());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private LoyaltyReward reward;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder reward(LoyaltyReward reward) {
            this.reward = reward;
            return this;
        }

        public RetrieveLoyaltyRewardResponse build() {
            RetrieveLoyaltyRewardResponse model = new RetrieveLoyaltyRewardResponse(this.errors, this.reward);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

